/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.auth;

import alpine.Config;
import alpine.common.logging.Logger;
import alpine.model.LdapUser;
import alpine.model.OidcUser;
import alpine.model.Permission;
import alpine.security.crypto.KeyManager;
import alpine.server.auth.IdentityProvider;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.SignatureException;
import java.security.Key;
import java.security.Principal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import org.owasp.security.logging.SecurityMarkers;

public class JsonWebToken {
    private static final Logger LOGGER = Logger.getLogger(JsonWebToken.class);
    private static final String IDENTITY_PROVIDER_CLAIM = "idp";
    private static String ISSUER = "Alpine";
    private final SecretKey key;
    private String subject;
    private Date expiration;
    private IdentityProvider identityProvider;

    public JsonWebToken(SecretKey key) {
        this.key = Keys.hmacShaKeyFor((byte[])key.getEncoded());
    }

    public JsonWebToken() {
        this(KeyManager.getInstance().getSecretKey());
    }

    public String createToken(Principal principal) {
        return this.createToken(principal, null);
    }

    public String createToken(Principal principal, List<Permission> permissions) {
        return this.createToken(principal, permissions, null);
    }

    public String createToken(Principal principal, List<Permission> permissions, IdentityProvider identityProvider) {
        int ttl = Config.getInstance().getPropertyAsInt((Config.Key)Config.AlpineKey.AUTH_JWT_TTL_SECONDS);
        return this.createToken(principal, permissions, identityProvider, ttl);
    }

    public String createToken(Principal principal, List<Permission> permissions, IdentityProvider identityProvider, int ttlSeconds) {
        Date now = new Date();
        JwtBuilder jwtBuilder = Jwts.builder();
        jwtBuilder.subject(principal.getName());
        jwtBuilder.issuer(ISSUER);
        jwtBuilder.issuedAt(now);
        jwtBuilder.expiration(this.addSeconds(now, ttlSeconds));
        if (permissions != null) {
            jwtBuilder.claim("permissions", (Object)permissions.stream().map(Permission::getName).collect(Collectors.joining(",")));
        }
        if (identityProvider != null) {
            jwtBuilder.claim(IDENTITY_PROVIDER_CLAIM, (Object)identityProvider.name());
        } else if (principal instanceof LdapUser) {
            jwtBuilder.claim(IDENTITY_PROVIDER_CLAIM, (Object)IdentityProvider.LDAP.name());
        } else if (principal instanceof OidcUser) {
            jwtBuilder.claim(IDENTITY_PROVIDER_CLAIM, (Object)IdentityProvider.OPENID_CONNECT.name());
        } else {
            jwtBuilder.claim(IDENTITY_PROVIDER_CLAIM, (Object)IdentityProvider.LOCAL.name());
        }
        return jwtBuilder.signWith((Key)this.key).compact();
    }

    public String createToken(Map<String, Object> claims) {
        JwtBuilder jwtBuilder = Jwts.builder();
        jwtBuilder.claims(claims);
        return jwtBuilder.signWith((Key)this.key).compact();
    }

    public boolean validateToken(String token) {
        try {
            JwtParser jwtParser = Jwts.parser().verifyWith(this.key).build();
            Jws claims = jwtParser.parseSignedClaims((CharSequence)token);
            this.subject = ((Claims)claims.getPayload()).getSubject();
            this.expiration = ((Claims)claims.getPayload()).getExpiration();
            this.identityProvider = IdentityProvider.forName((String)((Claims)claims.getPayload()).get(IDENTITY_PROVIDER_CLAIM, String.class));
            return true;
        }
        catch (SignatureException e) {
            LOGGER.info(SecurityMarkers.SECURITY_FAILURE, "Received token that did not pass signature verification");
        }
        catch (ExpiredJwtException e) {
            LOGGER.debug(SecurityMarkers.SECURITY_FAILURE, "Received expired token");
        }
        catch (MalformedJwtException e) {
            LOGGER.debug(SecurityMarkers.SECURITY_FAILURE, "Received malformed token");
            LOGGER.debug(SecurityMarkers.SECURITY_FAILURE, e.getMessage());
        }
        catch (UnsupportedJwtException | IllegalArgumentException e) {
            LOGGER.error(SecurityMarkers.SECURITY_FAILURE, e.getMessage());
        }
        return false;
    }

    private Date addSeconds(Date date, int seconds) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(13, seconds);
        return cal.getTime();
    }

    public String getSubject() {
        return this.subject;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public IdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    static {
        if (Config.getInstance().getApplicationName() != null) {
            ISSUER = Config.getInstance().getApplicationName();
        } else {
            Config.getInstance().getFrameworkName();
        }
    }
}

