/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public abstract class AbstractCacheManager {
    private final long expiresAfter;
    private final TimeUnit timeUnit;
    private final long maxSize;
    private final ConcurrentHashMap<Class, Cache<String, Object>> typeMap = new ConcurrentHashMap();

    protected AbstractCacheManager(long expiresAfter, TimeUnit timeUnit, long maxSize) {
        this.expiresAfter = expiresAfter;
        this.timeUnit = timeUnit;
        this.maxSize = maxSize;
    }

    public <T> T get(Class clazz, String key) {
        Cache<String, Object> cache = this.typeMap.get(clazz);
        return (T)(cache == null ? null : cache.getIfPresent((Object)key));
    }

    public <T> T get(Class clazz, String key, Function mappingFunction) {
        Cache<String, Object> cache = this.typeMap.get(clazz);
        return (T)(cache == null ? null : cache.get((Object)key, mappingFunction));
    }

    public void put(String key, Object object) {
        Cache<String, Object> cache = this.typeMap.get(object.getClass());
        if (cache == null) {
            cache = this.buildCache();
            this.typeMap.put(object.getClass(), cache);
        }
        cache.put((Object)key, object);
    }

    public void remove(Class clazz, String key) {
        Cache<String, Object> cache = this.typeMap.get(clazz);
        if (cache != null) {
            cache.invalidate((Object)key);
        }
    }

    public void maintenance(Class clazz) {
        this.typeMap.get(clazz).cleanUp();
    }

    private Cache<String, Object> buildCache() {
        return Caffeine.newBuilder().expireAfterWrite(this.expiresAfter, this.timeUnit).maximumSize(this.maxSize).build();
    }
}

