/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.filters;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public final class FqdnForwardFilter
implements Filter {
    private String host = null;

    public void init(FilterConfig filterConfig) {
        String host = filterConfig.getInitParameter("host");
        if (StringUtils.isNotBlank((CharSequence)host)) {
            this.host = host;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (req.getServerName().equals(this.host)) {
            chain.doFilter(request, response);
            return;
        }
        res.setStatus(301);
        StringBuilder sb = new StringBuilder();
        sb.append("http");
        if (req.isSecure()) {
            sb.append("s");
        }
        sb.append("://").append(this.host);
        if (StringUtils.isNotBlank((CharSequence)req.getPathInfo())) {
            sb.append(req.getPathInfo());
        }
        if (StringUtils.isNotBlank((CharSequence)req.getQueryString())) {
            sb.append("?").append(req.getQueryString());
        }
        res.setHeader("Location", sb.toString());
    }

    public void destroy() {
    }
}

