/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.filters;

import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.uri.UriTemplate;
import org.slf4j.MDC;

@Provider
@Priority(value=2)
public class RequestMdcEnrichmentFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Pattern TRIM_SLASHES_PATTERN = Pattern.compile("//+");

    public void filter(ContainerRequestContext requestContext) throws IOException {
        MDC.put((String)"requestMethod", (String)requestContext.getMethod());
        MDC.put((String)"requestUri", (String)this.getRequestUri(requestContext));
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        MDC.remove((String)"requestMethod");
        MDC.remove((String)"requestUri");
    }

    private String getRequestUri(ContainerRequestContext requestContext) {
        if (!(requestContext instanceof ContainerRequest)) {
            throw new IllegalStateException();
        }
        ContainerRequest containerRequest = (ContainerRequest)requestContext;
        ExtendedUriInfo uriInfo = containerRequest.getUriInfo();
        if (uriInfo.getMatchedTemplates().isEmpty()) {
            return null;
        }
        StringJoiner pathJoiner = new StringJoiner("/");
        for (UriTemplate uriTemplate : uriInfo.getMatchedTemplates().reversed()) {
            pathJoiner.add(uriTemplate.getTemplate());
        }
        return TRIM_SLASHES_PATTERN.matcher(pathJoiner.toString()).replaceAll("/");
    }
}

