/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.filters;

import alpine.common.logging.Logger;
import alpine.model.ApiKey;
import alpine.model.UserPrincipal;
import alpine.persistence.AlpineQueryManager;
import alpine.server.auth.PermissionRequired;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import org.glassfish.jersey.server.ContainerRequest;
import org.owasp.security.logging.SecurityMarkers;

@Priority(value=2000)
public class AuthorizationFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = Logger.getLogger(AuthorizationFilter.class);
    public static final String EFFECTIVE_PERMISSIONS_PROPERTY = "effectivePermissions";
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext) {
        if (requestContext instanceof ContainerRequest) {
            Set effectivePermissions;
            Principal principal = (Principal)requestContext.getProperty("Principal");
            if (principal == null) {
                LOGGER.info(SecurityMarkers.SECURITY_FAILURE, "A request was made without the assertion of a valid user principal");
                requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
                return;
            }
            PermissionRequired annotation = this.resourceInfo.getResourceMethod().getDeclaredAnnotation(PermissionRequired.class);
            Set<String> permissions = Set.of(annotation.value());
            try (AlpineQueryManager qm = new AlpineQueryManager();){
                effectivePermissions = qm.getEffectivePermissions(principal);
            }
            boolean hasNoRequiredPermission = Collections.disjoint(permissions, effectivePermissions);
            if (hasNoRequiredPermission) {
                String requestUri = requestContext.getUriInfo().getRequestUri().toString();
                if (principal instanceof ApiKey) {
                    ApiKey apiKey = (ApiKey)principal;
                    LOGGER.info(SecurityMarkers.SECURITY_FAILURE, "Unauthorized access attempt made by API Key %s to %s".formatted(apiKey.getMaskedKey(), requestUri));
                } else if (principal instanceof UserPrincipal) {
                    UserPrincipal user = (UserPrincipal)principal;
                    LOGGER.info(SecurityMarkers.SECURITY_FAILURE, "Unauthorized access attempt made by %s to %s".formatted(user.getUsername(), requestUri));
                } else {
                    throw new IllegalStateException("Unexpected principal type: " + principal.getClass().getName());
                }
                requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
            } else {
                requestContext.setProperty(EFFECTIVE_PERMISSIONS_PROPERTY, (Object)effectivePermissions);
            }
        }
    }
}

