/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.filters;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public final class WhitelistUrlFilter
implements Filter {
    private String[] allowUrls = new String[0];
    private String[] forwardExcludes = new String[0];
    private String forwardTo = null;

    public void init(FilterConfig filterConfig) {
        String forwardToParam;
        String forwardExcludesParam;
        String allowParam = filterConfig.getInitParameter("allowUrls");
        if (StringUtils.isNotBlank((CharSequence)allowParam)) {
            this.allowUrls = allowParam.split(",");
        }
        if (StringUtils.isNotBlank((CharSequence)(forwardExcludesParam = filterConfig.getInitParameter("forwardExcludes")))) {
            this.forwardExcludes = forwardExcludesParam.split(",");
        }
        if (StringUtils.isNotBlank((CharSequence)(forwardToParam = filterConfig.getInitParameter("forwardTo")))) {
            this.forwardTo = forwardToParam;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        try {
            String requestUri = new URI(req.getRequestURI()).normalize().getPath();
            if (requestUri != null) {
                if (requestUri.contains("..")) {
                    res.setStatus(400);
                    return;
                }
                boolean allowed = false;
                String requestUrlExcludingContext = requestUri.substring(req.getContextPath().length());
                for (String url : this.allowUrls) {
                    if (requestUrlExcludingContext.equals("/")) {
                        if (!url.trim().equals("/") && !url.trim().equals("/index.jsp") && !url.trim().equals("/index.html")) continue;
                        allowed = true;
                        continue;
                    }
                    if (!requestUrlExcludingContext.startsWith(url.trim())) continue;
                    allowed = true;
                }
                if (!allowed) {
                    if (this.forwardTo != null) {
                        for (String url : this.allowUrls) {
                            int occurrence;
                            if (this.forwardExcludes != null) {
                                if (Arrays.stream(this.forwardExcludes).anyMatch(url::equals)) break;
                            }
                            if ((occurrence = requestUrlExcludingContext.indexOf(url)) <= -1) continue;
                            String queryString = req.getQueryString() == null ? "" : "?" + req.getQueryString();
                            String resourceUrl = requestUrlExcludingContext.substring(occurrence) + queryString;
                            req.getRequestDispatcher(resourceUrl).forward(request, response);
                            return;
                        }
                        req.getRequestDispatcher(this.forwardTo).forward(request, response);
                    } else {
                        res.setStatus(404);
                    }
                    return;
                }
            }
        }
        catch (URISyntaxException e) {
            res.setStatus(400);
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean isExcludedForwardPath(String url) {
        return Arrays.stream(this.forwardExcludes).anyMatch(url::equals);
    }

    public void destroy() {
    }
}

