/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.health.checks;

import alpine.common.logging.Logger;
import alpine.server.persistence.PersistenceManagerFactory;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.jdo.Transaction;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
public class DatabaseHealthCheck
implements HealthCheck {
    private static final Logger LOGGER = Logger.getLogger(DatabaseHealthCheck.class);

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder responseBuilder = HealthCheckResponse.named((String)"database");
        try (PersistenceManager pm = PersistenceManagerFactory.createPersistenceManager();){
            HealthCheckResponse.Status nonTransactionalStatus = this.checkNonTransactionalConnectionPool(pm);
            HealthCheckResponse.Status transactionalStatus = this.checkTransactionalConnectionPool(pm);
            responseBuilder.status(nonTransactionalStatus == HealthCheckResponse.Status.UP && transactionalStatus == HealthCheckResponse.Status.UP).withData("nontx_connection_pool", nonTransactionalStatus.name()).withData("tx_connection_pool", transactionalStatus.name());
        }
        catch (Exception e) {
            LOGGER.error("Executing database health check failed", (Throwable)e);
            responseBuilder.down().withData("exception_message", e.getMessage());
        }
        return responseBuilder.build();
    }

    private HealthCheckResponse.Status checkNonTransactionalConnectionPool(PersistenceManager pm) {
        LOGGER.debug("Checking non-transactional connection pool");
        try {
            return this.executeQuery(pm);
        }
        catch (Exception e) {
            LOGGER.error("Checking non-transactional connection pool failed", (Throwable)e);
            return HealthCheckResponse.Status.DOWN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HealthCheckResponse.Status checkTransactionalConnectionPool(PersistenceManager pm) {
        LOGGER.debug("Checking transactional connection pool");
        Transaction trx = pm.currentTransaction();
        trx.setRollbackOnly();
        try {
            trx.begin();
            HealthCheckResponse.Status status = this.executeQuery(pm);
            return status;
        }
        catch (Exception e) {
            LOGGER.error("Checking transactional connection pool failed", (Throwable)e);
            HealthCheckResponse.Status status = HealthCheckResponse.Status.DOWN;
            return status;
        }
        finally {
            if (trx.isActive()) {
                trx.rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HealthCheckResponse.Status executeQuery(PersistenceManager pm) {
        Query query = pm.newQuery("javax.jdo.query.SQL", (Object)"SELECT 1");
        try {
            query.executeResultUnique(Long.class);
            HealthCheckResponse.Status status = HealthCheckResponse.Status.UP;
            return status;
        }
        finally {
            query.closeAll();
        }
    }
}

