/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.persistence;

import alpine.common.AboutProvider;
import alpine.common.logging.Logger;
import alpine.server.persistence.PersistenceManagerFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.jdo.PersistenceManager;
import javax.jdo.datastore.JDOConnection;

public class DatabaseAboutProvider
implements AboutProvider {
    private static final Logger LOGGER = Logger.getLogger(DatabaseAboutProvider.class);

    public String name() {
        return "database";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> collect() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        try (PersistenceManager pm = PersistenceManagerFactory.createPersistenceManager();){
            JDOConnection jdoConnection = pm.getDataStoreConnection();
            Connection nativeConnection = (Connection)jdoConnection.getNativeConnection();
            try {
                DatabaseMetaData databaseMetaData = nativeConnection.getMetaData();
                data.put("productName", databaseMetaData.getDatabaseProductName());
                data.put("productVersion", databaseMetaData.getDatabaseProductVersion());
            }
            catch (SQLException e) {
                LOGGER.error("Failed to retrieve database metadata", (Throwable)e);
            }
            finally {
                jdoConnection.close();
            }
        }
        return data;
    }
}

