/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.servlets;

import alpine.Config;
import alpine.common.logging.Logger;
import alpine.common.metrics.Metrics;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.owasp.security.logging.SecurityMarkers;

public class MetricsServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(MetricsServlet.class);
    private final Config config;
    private boolean metricsEnabled;
    private String basicAuthUsername;
    private String basicAuthPassword;

    public MetricsServlet() {
        this(Config.getInstance());
    }

    MetricsServlet(Config config) {
        this.config = config;
    }

    public void init() throws ServletException {
        this.metricsEnabled = this.config.getPropertyAsBoolean((Config.Key)Config.AlpineKey.METRICS_ENABLED);
        this.basicAuthUsername = this.config.getProperty((Config.Key)Config.AlpineKey.METRICS_AUTH_USERNAME);
        this.basicAuthPassword = this.config.getProperty((Config.Key)Config.AlpineKey.METRICS_AUTH_PASSWORD);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.isAuthenticationEnabled() && !this.isAuthenticated(req)) {
            LOGGER.warn(SecurityMarkers.SECURITY_AUDIT, "Unauthorized access attempt (IP address: " + req.getRemoteAddr() + " / User-Agent: " + req.getHeader("User-Agent") + ")");
            resp.setStatus(401);
            resp.setHeader("WWW-Authenticate", "Basic realm=\"metrics\"");
            return;
        }
        if (this.metricsEnabled) {
            resp.setStatus(200);
            resp.setHeader("Content-Type", "text/plain; version=0.0.4; charset=utf-8");
            Metrics.getRegistry().scrape((OutputStream)resp.getOutputStream());
        } else {
            resp.setStatus(404);
        }
    }

    private boolean isAuthenticationEnabled() {
        return StringUtils.isNotBlank((CharSequence)this.basicAuthUsername) && StringUtils.isNotBlank((CharSequence)this.basicAuthPassword);
    }

    private boolean isAuthenticated(HttpServletRequest req) {
        String credentials;
        String authHeader = req.getHeader("Authorization");
        if (StringUtils.isBlank((CharSequence)authHeader)) {
            LOGGER.debug("No Authorization header provided");
            return false;
        }
        String[] headerParts = authHeader.split(" ");
        if (headerParts.length != 2 || !"basic".equalsIgnoreCase(headerParts[0])) {
            LOGGER.debug("Invalid Authorization header format");
            return false;
        }
        try {
            byte[] credentialsBytes = Base64.getUrlDecoder().decode(headerParts[1]);
            credentials = new String(credentialsBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.debug("Decoding basic auth credentials failed", (Throwable)e);
            return false;
        }
        String[] credentialsParts = credentials.split(":");
        if (credentialsParts.length != 2) {
            LOGGER.debug("Invalid basic auth credentials format");
            return false;
        }
        return StringUtils.equals((CharSequence)this.basicAuthUsername, (CharSequence)credentialsParts[0]) && StringUtils.equals((CharSequence)this.basicAuthPassword, (CharSequence)credentialsParts[1]);
    }
}

