/*
 * Decompiled with CFR 0.152.
 */
package alpine.auth;

import alpine.auth.AlpineAuthenticationException;
import alpine.auth.AuthenticationService;
import alpine.auth.PasswordService;
import alpine.logging.Logger;
import alpine.model.ManagedUser;
import alpine.persistence.AlpineQueryManager;
import java.security.Principal;

public class ManagedUserAuthenticationService
implements AuthenticationService {
    private static final Logger LOGGER = Logger.getLogger(ManagedUserAuthenticationService.class);
    private final String username;
    private final String password;

    public ManagedUserAuthenticationService(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public boolean isSpecified() {
        return true;
    }

    @Override
    public Principal authenticate() throws AlpineAuthenticationException {
        LOGGER.debug("Attempting to authenticate user: " + this.username);
        try (AlpineQueryManager qm = new AlpineQueryManager();){
            ManagedUser user = qm.getManagedUser(this.username);
            if (user != null && PasswordService.matches(this.password.toCharArray(), user)) {
                if (user.isSuspended()) {
                    throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.SUSPENDED, user);
                }
                if (user.isForcePasswordChange()) {
                    throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.FORCE_PASSWORD_CHANGE, user);
                }
                ManagedUser managedUser = user;
                return managedUser;
            }
        }
        throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.INVALID_CREDENTIALS);
    }
}

