/*
 * Decompiled with CFR 0.152.
 */
package alpine.auth;

import alpine.auth.AlpineAuthenticationException;
import alpine.auth.OidcConfiguration;
import alpine.auth.OidcProfile;
import alpine.auth.OidcProfileCreator;
import alpine.cache.CacheManager;
import alpine.logging.Logger;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.validators.IDTokenValidator;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;

class OidcIdTokenAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(OidcIdTokenAuthenticator.class);
    static final String JWK_SET_CACHE_KEY = "OIDC_JWK_SET";
    private final OidcConfiguration configuration;
    private final String clientId;

    OidcIdTokenAuthenticator(OidcConfiguration configuration, String clientId) {
        this.configuration = configuration;
        this.clientId = clientId;
    }

    OidcProfile authenticate(String idToken, OidcProfileCreator profileCreator) throws AlpineAuthenticationException {
        IDTokenClaimsSet claimsSet;
        JWKSet jwkSet;
        SignedJWT parsedIdToken;
        try {
            parsedIdToken = SignedJWT.parse((String)idToken);
        }
        catch (ParseException e) {
            LOGGER.error("Parsing ID token failed", e);
            throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.INVALID_CREDENTIALS);
        }
        try {
            jwkSet = this.resolveJwkSet();
        }
        catch (IOException | ParseException e) {
            LOGGER.error("Resolving JWK set failed", e);
            throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.OTHER);
        }
        IDTokenValidator idTokenValidator = new IDTokenValidator(new Issuer(this.configuration.getIssuer()), new ClientID(this.clientId), parsedIdToken.getHeader().getAlgorithm(), jwkSet);
        try {
            claimsSet = idTokenValidator.validate((JWT)parsedIdToken, null);
            LOGGER.debug("ID token claims: " + claimsSet.toJSONString());
        }
        catch (JOSEException | BadJOSEException e) {
            LOGGER.error("ID token validation failed", e);
            throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.INVALID_CREDENTIALS);
        }
        return profileCreator.create((ClaimsSet)claimsSet);
    }

    JWKSet resolveJwkSet() throws IOException, ParseException {
        JWKSet jwkSet = (JWKSet)CacheManager.getInstance().get(JWKSet.class, JWK_SET_CACHE_KEY);
        if (jwkSet != null) {
            LOGGER.debug("JWK set loaded from cache");
            return jwkSet;
        }
        LOGGER.debug("Fetching JWK set from " + this.configuration.getJwksUri());
        jwkSet = JWKSet.load((URL)this.configuration.getJwksUri().toURL());
        LOGGER.debug("Storing JWK set in cache");
        CacheManager.getInstance().put(JWK_SET_CACHE_KEY, jwkSet);
        return jwkSet;
    }
}

