/*
 * Decompiled with CFR 0.152.
 */
package alpine.event.framework;

import alpine.event.framework.BaseEventService;
import alpine.event.framework.LoggableUncaughtExceptionHandler;
import alpine.logging.Logger;
import alpine.util.ThreadUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;

public final class EventService
extends BaseEventService {
    private static final EventService INSTANCE = new EventService();
    private static final Logger LOGGER = Logger.getLogger(EventService.class);
    private static final ExecutorService EXECUTOR;

    private EventService() {
    }

    public static EventService getInstance() {
        return INSTANCE;
    }

    static {
        BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern("Alpine-EventService-%d").uncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new LoggableUncaughtExceptionHandler()).build();
        EXECUTOR = Executors.newFixedThreadPool(ThreadUtil.determineNumberOfWorkerThreads(), (ThreadFactory)factory);
        INSTANCE.setExecutorService(EXECUTOR);
        INSTANCE.setLogger(LOGGER);
    }
}

