/*
 * Decompiled with CFR 0.152.
 */
package alpine.filters;

import alpine.resources.AlpineRequest;
import alpine.resources.OrderDirection;
import alpine.resources.Pagination;
import alpine.validation.RegexSequence;
import java.security.Principal;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.server.ContainerRequest;

@Provider
@Priority(value=5000)
public class ApiFilter
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext requestContext) {
        if (requestContext instanceof ContainerRequest) {
            ContainerRequest request = (ContainerRequest)requestContext;
            MultivaluedMap queryParams = request.getUriInfo().getQueryParameters();
            String offset = this.multiParam((MultivaluedMap<String, String>)queryParams, "offset");
            String page = this.multiParam((MultivaluedMap<String, String>)queryParams, "page", "pageNumber");
            String size = this.multiParam((MultivaluedMap<String, String>)queryParams, "size", "pageSize", "limit");
            String filter = this.multiParam((MultivaluedMap<String, String>)queryParams, "filter", "searchText");
            String sort = this.multiParam((MultivaluedMap<String, String>)queryParams, "sort", "sortOrder");
            String orderBy = this.multiParam((MultivaluedMap<String, String>)queryParams, "orderBy", "sortName");
            if (StringUtils.isBlank((CharSequence)orderBy) || !RegexSequence.Pattern.STRING_IDENTIFIER.matcher(orderBy).matches()) {
                orderBy = null;
            }
            OrderDirection orderDirection = "asc".equalsIgnoreCase(sort) ? OrderDirection.ASCENDING : ("desc".equalsIgnoreCase(sort) ? OrderDirection.DESCENDING : OrderDirection.UNSPECIFIED);
            Pagination pagination = StringUtils.isNotBlank((CharSequence)offset) ? new Pagination(Pagination.Strategy.OFFSET, offset, size) : (StringUtils.isNotBlank((CharSequence)page) && StringUtils.isNotBlank((CharSequence)size) ? new Pagination(Pagination.Strategy.PAGES, page, size) : new Pagination(Pagination.Strategy.OFFSET, 0, 100));
            AlpineRequest alpineRequest = new AlpineRequest(this.getPrincipal(requestContext), pagination, filter, orderBy, orderDirection);
            requestContext.setProperty("AlpineRequest", (Object)alpineRequest);
        }
    }

    private String multiParam(MultivaluedMap<String, String> queryParams, String ... params) {
        for (String param : params) {
            String value = (String)queryParams.getFirst((Object)param);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            return value;
        }
        return null;
    }

    private Principal getPrincipal(ContainerRequestContext requestContext) {
        Object principal = requestContext.getProperty("Principal");
        if (principal != null) {
            return (Principal)principal;
        }
        return null;
    }
}

