/*
 * Decompiled with CFR 0.152.
 */
package alpine.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public final class ContentSecurityPolicyFilter
implements Filter {
    private static final String SELF = "'self'";
    private static final String NONE = "'none'";
    private String policy = null;
    private String defaultSrc = "'self'";
    private String scriptSrc = "'self'";
    private String styleSrc = "'self'";
    private String imgSrc = "'self'";
    private String connectSrc = "'self'";
    private String fontSrc = "'self'";
    private String objectSrc = "'self'";
    private String mediaSrc = "'self'";
    private String frameSrc = "'self'";
    private String sandbox = null;
    private String reportUri = null;
    private String childSrc = "'self'";
    private String formAction = "'self'";
    private String frameAncestors = "'none'";
    private String pluginTypes = null;

    public void init(FilterConfig filterConfig) {
        this.defaultSrc = this.getValue(filterConfig, "default-src", this.defaultSrc);
        this.scriptSrc = this.getValue(filterConfig, "script-src", this.scriptSrc);
        this.styleSrc = this.getValue(filterConfig, "style-src", this.styleSrc);
        this.imgSrc = this.getValue(filterConfig, "img-src", this.imgSrc);
        this.connectSrc = this.getValue(filterConfig, "connect-src", this.connectSrc);
        this.fontSrc = this.getValue(filterConfig, "font-src", this.fontSrc);
        this.objectSrc = this.getValue(filterConfig, "object-src", this.objectSrc);
        this.mediaSrc = this.getValue(filterConfig, "media-src", this.mediaSrc);
        this.frameSrc = this.getValue(filterConfig, "frame-src", this.frameSrc);
        this.sandbox = this.getValue(filterConfig, "sandbox", this.sandbox);
        this.reportUri = this.getValue(filterConfig, "report-uri", this.reportUri);
        this.childSrc = this.getValue(filterConfig, "child-src", this.childSrc);
        this.formAction = this.getValue(filterConfig, "form-action", this.formAction);
        this.frameAncestors = this.getValue(filterConfig, "frame-ancestors", this.frameAncestors);
        this.pluginTypes = this.getValue(filterConfig, "plugin-types", this.pluginTypes);
        this.policy = this.formatHeader();
    }

    private String getValue(FilterConfig filterConfig, String initParam, String variable) {
        String value = filterConfig.getInitParameter(initParam);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        return variable;
    }

    private String formatHeader() {
        StringBuilder sb = new StringBuilder();
        this.getStringFromValue(sb, "default-src", this.defaultSrc);
        this.getStringFromValue(sb, "script-src", this.scriptSrc);
        this.getStringFromValue(sb, "style-src", this.styleSrc);
        this.getStringFromValue(sb, "img-src", this.imgSrc);
        this.getStringFromValue(sb, "connect-src", this.connectSrc);
        this.getStringFromValue(sb, "font-src", this.fontSrc);
        this.getStringFromValue(sb, "object-src", this.objectSrc);
        this.getStringFromValue(sb, "media-src", this.mediaSrc);
        this.getStringFromValue(sb, "frame-src", this.frameSrc);
        this.getStringFromValue(sb, "sandbox", this.sandbox);
        this.getStringFromValue(sb, "report-uri", this.reportUri);
        this.getStringFromValue(sb, "child-src", this.childSrc);
        this.getStringFromValue(sb, "form-action", this.formAction);
        this.getStringFromValue(sb, "frame-ancestors", this.frameAncestors);
        this.getStringFromValue(sb, "plugin-types", this.pluginTypes);
        return sb.toString().replaceAll("(\\[|\\])", "").trim();
    }

    private void getStringFromValue(StringBuilder builder, String directive, String value) {
        if (value != null) {
            builder.append(directive).append(" ").append(value).append(";");
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)res;
        chain.doFilter(req, (ServletResponse)response);
        response.addHeader("Content-Security-Policy", this.policy);
    }

    public void destroy() {
    }
}

