/*
 * Decompiled with CFR 0.152.
 */
package alpine.persistence;

import alpine.Config;
import alpine.logging.Logger;
import alpine.model.InstalledUpgrades;
import alpine.model.SchemaVersion;
import alpine.persistence.JdoProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.store.schema.SchemaAwareStoreManager;

public class PersistenceManagerFactory
implements ServletContextListener {
    private static final Logger LOGGER = Logger.getLogger(PersistenceManagerFactory.class);
    private static JDOPersistenceManagerFactory pmf;

    public void contextInitialized(ServletContextEvent event) {
        LOGGER.info("Initializing persistence framework");
        pmf = (JDOPersistenceManagerFactory)JDOHelper.getPersistenceManagerFactory((Map)JdoProperties.get(), (String)"Alpine");
        PersistenceNucleusContext ctx = pmf.getNucleusContext();
        HashSet<String> classNames = new HashSet<String>();
        classNames.add(InstalledUpgrades.class.getCanonicalName());
        classNames.add(SchemaVersion.class.getCanonicalName());
        ((SchemaAwareStoreManager)ctx.getStoreManager()).createSchemaForClasses(classNames, new Properties());
    }

    public void contextDestroyed(ServletContextEvent event) {
        LOGGER.info("Shutting down persistence framework");
        pmf.close();
    }

    public static PersistenceManager createPersistenceManager() {
        if (Config.isUnitTestsEnabled()) {
            pmf = (JDOPersistenceManagerFactory)JDOHelper.getPersistenceManagerFactory((Map)JdoProperties.unit(), (String)"Alpine");
        }
        if (pmf == null) {
            throw new IllegalStateException("Context is not initialized yet.");
        }
        return pmf.getPersistenceManager();
    }
}

