/*
 * Decompiled with CFR 0.152.
 */
package alpine.resources;

public class Pagination {
    private final Strategy strategy;
    private int offset;
    private int limit;

    public Pagination(Strategy strategy, int o1, int o2) {
        this.strategy = strategy;
        this.calculateStrategy(strategy, o1, o2);
    }

    public Pagination(Strategy strategy, String o1, String o2) {
        this.strategy = strategy;
        if (Strategy.OFFSET == strategy) {
            this.calculateStrategy(strategy, this.parseIntegerFromParam(o1, 0), this.parseIntegerFromParam(o2, 100));
        } else if (Strategy.PAGES == strategy) {
            this.calculateStrategy(strategy, this.parseIntegerFromParam(o1, 1), this.parseIntegerFromParam(o2, 100));
        }
    }

    private void calculateStrategy(Strategy strategy, int o1, int o2) {
        if (Strategy.OFFSET == strategy) {
            this.offset = o1;
            this.limit = o2;
        } else if (Strategy.PAGES == strategy) {
            this.offset = o1 * o2 - o2;
            this.limit = o2;
        }
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isPaginated() {
        return (Strategy.OFFSET == this.strategy || Strategy.PAGES == this.strategy) && this.limit > 0;
    }

    private Integer parseIntegerFromParam(String value, int defaultValue) {
        try {
            return Integer.valueOf(value);
        }
        catch (NullPointerException | NumberFormatException e) {
            return defaultValue;
        }
    }

    public static enum Strategy {
        OFFSET,
        PAGES,
        NONE;

    }
}

