/*
 * Decompiled with CFR 0.152.
 */
package alpine.tasks;

import alpine.event.framework.Event;
import alpine.event.framework.EventService;
import alpine.event.framework.SingleThreadedEventService;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public abstract class AlpineTaskScheduler {
    private final List<Timer> timers = new ArrayList<Timer>();

    protected void scheduleEvent(Event event, long delay, long period) {
        Timer timer = new Timer();
        timer.schedule((TimerTask)new ScheduleEvent().event(event), delay, period);
        this.timers.add(timer);
    }

    public void shutdown() {
        for (Timer timer : this.timers) {
            timer.cancel();
        }
    }

    private class ScheduleEvent
    extends TimerTask {
        private Event event;

        private ScheduleEvent() {
        }

        public ScheduleEvent event(Event event) {
            this.event = event;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ScheduleEvent scheduleEvent = this;
            synchronized (scheduleEvent) {
                EventService.getInstance().publish(this.event);
                SingleThreadedEventService.getInstance().publish(this.event);
            }
        }
    }
}

