/*
 * Decompiled with CFR 0.152.
 */
package alpine.tasks;

import alpine.auth.LdapConnectionWrapper;
import alpine.event.LdapSyncEvent;
import alpine.event.framework.Event;
import alpine.event.framework.Subscriber;
import alpine.logging.Logger;
import alpine.model.LdapUser;
import alpine.persistence.AlpineQueryManager;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;

public class LdapSyncTask
implements Subscriber {
    private static final Logger LOGGER = Logger.getLogger(LdapSyncTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inform(Event e) {
        if (!LdapConnectionWrapper.LDAP_CONFIGURED) {
            return;
        }
        if (e instanceof LdapSyncEvent) {
            LOGGER.info("Starting LDAP synchronization task");
            LdapSyncEvent event = (LdapSyncEvent)e;
            LdapConnectionWrapper ldap = new LdapConnectionWrapper();
            DirContext ctx = null;
            try {
                try (AlpineQueryManager qm = new AlpineQueryManager();){
                    ctx = ldap.createDirContext();
                    if (event.getUsername() == null) {
                        List<LdapUser> users = qm.getLdapUsers();
                        for (LdapUser user : users) {
                            this.sync(ctx, qm, ldap, user);
                        }
                    } else {
                        LdapUser user = qm.getLdapUser(event.getUsername());
                        if (user != null) {
                            this.sync(ctx, qm, ldap, user);
                        }
                    }
                }
                ldap.closeQuietly(ctx);
                LOGGER.info("LDAP synchronization complete");
            }
            catch (NamingException ex) {
                try {
                    LOGGER.error("Error occurred during LDAP synchronization", ex);
                    ldap.closeQuietly(ctx);
                    LOGGER.info("LDAP synchronization complete");
                }
                catch (Throwable throwable) {
                    ldap.closeQuietly(ctx);
                    LOGGER.info("LDAP synchronization complete");
                    throw throwable;
                }
            }
        }
    }

    private void sync(DirContext ctx, AlpineQueryManager qm, LdapConnectionWrapper ldap, LdapUser user) throws NamingException {
        LOGGER.debug("Syncing: " + user.getUsername());
        SearchResult result = ldap.searchForSingleUsername(ctx, user.getUsername());
        if (result != null) {
            user.setDN(result.getNameInNamespace());
            user.setEmail(ldap.getAttribute(result, LdapConnectionWrapper.ATTRIBUTE_MAIL));
            user = qm.updateLdapUser(user);
            if (LdapConnectionWrapper.TEAM_SYNCHRONIZATION) {
                List<String> groupDNs = ldap.getGroups(ctx, user);
                qm.synchronizeTeamMembership(user, groupDNs);
            }
        } else {
            user.setDN("INVALID");
            user.setEmail(null);
            user = qm.updateLdapUser(user);
            if (LdapConnectionWrapper.TEAM_SYNCHRONIZATION) {
                qm.synchronizeTeamMembership(user, new ArrayList<String>());
            }
        }
    }
}

