/*
 * Decompiled with CFR 0.152.
 */
package alpine.upgrade;

import alpine.logging.Logger;
import alpine.persistence.AlpineQueryManager;
import alpine.upgrade.UpgradeException;
import alpine.upgrade.UpgradeItem;
import alpine.upgrade.UpgradeMetaProcessor;
import alpine.util.DbUtil;
import alpine.util.VersionComparator;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.jdo.datastore.JDOConnection;

public class UpgradeExecutor {
    private static final Logger LOGGER = Logger.getLogger(UpgradeExecutor.class);
    private final AlpineQueryManager qm;

    public UpgradeExecutor(AlpineQueryManager qm) {
        this.qm = qm;
    }

    public void executeUpgrades(List<Class<? extends UpgradeItem>> classes) throws UpgradeException {
        Connection connection = this.getConnection(this.qm);
        UpgradeMetaProcessor installedUpgrades = new UpgradeMetaProcessor(connection);
        DbUtil.initPlatformName(connection);
        try {
            installedUpgrades.updateSchemaVersion(null);
        }
        catch (SQLException e) {
            LOGGER.error("Failed to update schema version", e);
            return;
        }
        for (Class<? extends UpgradeItem> upgradeClass : classes) {
            try {
                Constructor<? extends UpgradeItem> constructor = upgradeClass.getConstructor(new Class[0]);
                UpgradeItem upgradeItem = constructor.newInstance(new Object[0]);
                if (upgradeItem.shouldUpgrade(this.qm, connection)) {
                    if (!installedUpgrades.hasUpgradeRan(upgradeClass)) {
                        LOGGER.info("Upgrade class " + upgradeClass.getName() + " about to run.");
                        long startTime = System.currentTimeMillis();
                        upgradeItem.executeUpgrade(this.qm, connection);
                        long endTime = System.currentTimeMillis();
                        installedUpgrades.installUpgrade(upgradeClass, startTime, endTime);
                        installedUpgrades.updateSchemaVersion(new VersionComparator(upgradeItem.getSchemaVersion()));
                        LOGGER.info("Completed running upgrade class " + upgradeClass.getName() + " in " + (endTime - startTime) + " ms.");
                        continue;
                    }
                    LOGGER.debug("Upgrade class " + upgradeClass.getName() + " has already ran, skipping.");
                    continue;
                }
                LOGGER.debug("Upgrade class " + upgradeClass.getName() + " does not need to run.");
            }
            catch (Exception e) {
                DbUtil.rollback(connection);
                LOGGER.error("Error in executing upgrade class: " + upgradeClass.getName(), e);
                throw new UpgradeException(e);
            }
        }
    }

    private Connection getConnection(AlpineQueryManager aqm) {
        JDOConnection jdoConnection = aqm.getPersistenceManager().getDataStoreConnection();
        if (jdoConnection != null && jdoConnection.getNativeConnection() instanceof Connection) {
            return (Connection)jdoConnection.getNativeConnection();
        }
        return null;
    }
}

