/*
 * Decompiled with CFR 0.152.
 */
package alpine.upgrade;

import alpine.Config;
import alpine.logging.Logger;
import alpine.upgrade.UpgradeException;
import alpine.upgrade.UpgradeItem;
import alpine.util.DbUtil;
import alpine.util.VersionComparator;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class UpgradeMetaProcessor
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(UpgradeMetaProcessor.class);
    private final Connection connection;

    public UpgradeMetaProcessor(Connection connection) {
        this.connection = connection;
    }

    public UpgradeMetaProcessor() throws UpgradeException {
        this.connection = this.createConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUpgradeRan(Class<? extends UpgradeItem> upgradeClass) throws SQLException {
        boolean bl;
        PreparedStatement statement = null;
        ResultSet results = null;
        try {
            statement = this.connection.prepareStatement("SELECT \"UPGRADECLASS\" FROM \"INSTALLEDUPGRADES\" WHERE \"UPGRADECLASS\" = ?");
            statement.setString(1, upgradeClass.getCanonicalName());
            results = statement.executeQuery();
            bl = results.next();
        }
        catch (Throwable throwable) {
            DbUtil.close(results);
            DbUtil.close(statement);
            throw throwable;
        }
        DbUtil.close(results);
        DbUtil.close(statement);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installUpgrade(Class<? extends UpgradeItem> upgradeClass, long startTime, long endTime) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement("INSERT INTO \"INSTALLEDUPGRADES\" (\"UPGRADECLASS\", \"STARTTIME\", \"ENDTIME\") VALUES (?, ?, ?)");
            statement.setString(1, upgradeClass.getCanonicalName());
            statement.setTimestamp(2, new Timestamp(startTime));
            statement.setTimestamp(3, new Timestamp(endTime));
            statement.executeUpdate();
            this.connection.commit();
            LOGGER.debug("Added: " + upgradeClass.getCanonicalName() + " to UpgradeMetaProcessor table (Starttime: " + startTime + "; Endtime: " + endTime + ")");
        }
        catch (Throwable throwable) {
            DbUtil.close(statement);
            throw throwable;
        }
        DbUtil.close(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionComparator getSchemaVersion() {
        ResultSet results;
        PreparedStatement statement;
        block3: {
            VersionComparator versionComparator;
            statement = null;
            results = null;
            try {
                statement = this.connection.prepareStatement("SELECT \"VERSION\" FROM \"SCHEMAVERSION\"");
                results = statement.executeQuery();
                if (!results.next()) break block3;
                versionComparator = new VersionComparator(results.getString(1));
            }
            catch (SQLException sQLException) {
                DbUtil.close(results);
                DbUtil.close(statement);
            }
            catch (Throwable throwable) {
                DbUtil.close(results);
                DbUtil.close(statement);
                throw throwable;
            }
            DbUtil.close(results);
            DbUtil.close(statement);
            return versionComparator;
        }
        DbUtil.close(results);
        DbUtil.close(statement);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void updateSchemaVersion(VersionComparator version) throws SQLException {
        block4: {
            block3: {
                statement = null;
                updateStatement = null;
                results = null;
                try {
                    statement = this.connection.prepareStatement("SELECT \"VERSION\" FROM \"SCHEMAVERSION\"");
                    results = statement.executeQuery();
                    if (!results.next()) ** GOTO lbl23
                    currentVersion = new VersionComparator(results.getString(1));
                    if (version != null && !currentVersion.isNewerThan(version)) break block3;
                }
                catch (Throwable var6_6) {
                    DbUtil.close(results);
                    DbUtil.close(updateStatement);
                    DbUtil.close(statement);
                    throw var6_6;
                }
                DbUtil.close(results);
                DbUtil.close(updateStatement);
                DbUtil.close(statement);
                return;
            }
            updateStatement = this.connection.prepareStatement("UPDATE \"SCHEMAVERSION\" SET \"VERSION\" = ?");
            break block4;
lbl23:
            // 1 sources

            version = new VersionComparator(Config.getInstance().getApplicationVersion());
            updateStatement = this.connection.prepareStatement("INSERT INTO \"SCHEMAVERSION\" (\"VERSION\") VALUES (?)");
        }
        UpgradeMetaProcessor.LOGGER.debug("Updating database schema to: " + version.toString());
        updateStatement.setString(1, version.toString());
        updateStatement.executeUpdate();
        this.connection.commit();
        DbUtil.close(results);
        DbUtil.close(updateStatement);
        DbUtil.close(statement);
    }

    private Connection createConnection() throws UpgradeException {
        String driver = Config.getInstance().getProperty(Config.AlpineKey.DATABASE_DRIVER);
        String dbUrl = Config.getInstance().getProperty(Config.AlpineKey.DATABASE_URL);
        String user = Config.getInstance().getProperty(Config.AlpineKey.DATABASE_USERNAME);
        String password = Config.getInstance().getProperty(Config.AlpineKey.DATABASE_PASSWORD);
        try {
            Class.forName(driver);
            return DriverManager.getConnection(dbUrl, user, password);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Unable to load JDBC driver.", e);
            throw new UpgradeException("Unable to load JDBC driver.", e);
        }
        catch (SQLException e) {
            LOGGER.error("An error occurred connecting to the database.", e);
            throw new UpgradeException("An error occurred connecting to the database.", e);
        }
    }

    @Override
    public void close() {
        DbUtil.close(this.connection);
    }
}

