/*
 * Decompiled with CFR 0.152.
 */
package alpine.util;

import java.text.NumberFormat;

public class ByteFormat {
    private static final int BYTE = 1;
    private static final int KILOBYTE = 1024;
    private static final int MEGABYTE = 0x100000;
    private static final int GIGABYTE = 0x40000000;
    private static final long[] LIMITS = new long[]{0x40000000L, 0x100000L, 1024L, 1L};
    private final NumberFormat numberFormat = NumberFormat.getIntegerInstance();
    private String[] names = new String[]{" GB", " MB", " KB", " byte"};

    public ByteFormat() {
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(int count) {
        if (count < 0) {
            throw new NumberFormatException("ByteFormat: Byte count cannot be less than 0");
        }
        for (int i = 0; i < this.names.length; ++i) {
            if ((long)count < LIMITS[i]) continue;
            float fVal = (float)count / (float)LIMITS[i];
            String name = i == this.names.length - 1 && (double)fVal != 1.0 ? this.names[i] + "s" : this.names[i];
            NumberFormat numberFormat = this.numberFormat;
            synchronized (numberFormat) {
                return this.numberFormat.format(fVal) + name;
            }
        }
        return "0" + this.names[this.names.length - 1] + "s";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format2(int count) {
        if (count < 1024) {
            return this.format(count);
        }
        NumberFormat numberFormat = this.numberFormat;
        synchronized (numberFormat) {
            return this.format(count) + " (" + this.numberFormat.format(count) + " bytes)";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(long count) {
        if (count <= Integer.MAX_VALUE) {
            return this.format((int)count);
        }
        double dVal = (double)count / (double)LIMITS[0];
        NumberFormat numberFormat = this.numberFormat;
        synchronized (numberFormat) {
            return this.numberFormat.format(dVal) + this.names[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format2(long count) {
        if (count < 1024L) {
            return this.format(count);
        }
        NumberFormat numberFormat = this.numberFormat;
        synchronized (numberFormat) {
            return this.format(count) + " (" + this.numberFormat.format(count) + " bytes)";
        }
    }

    public void setMinimumFractionDigits(int d) {
        this.numberFormat.setMinimumFractionDigits(d);
    }

    public ByteFormat minimumFractionDigits(int d) {
        this.setMinimumFractionDigits(d);
        return this;
    }

    public void setMaximumFractionDigits(int d) {
        this.numberFormat.setMaximumFractionDigits(d);
    }

    public ByteFormat maximumFractionDigits(int d) {
        this.setMaximumFractionDigits(d);
        return this;
    }

    public void setNames(String[] names) {
        this.names = names == null ? null : (String[])names.clone();
    }

    public ByteFormat names(String[] names) {
        this.setNames(names);
        return this;
    }
}

