/*
 * Decompiled with CFR 0.152.
 */
package alpine.util;

import alpine.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public final class SystemUtil {
    private static boolean hasInitialized;
    private static boolean isWindows;
    private static boolean isMac;
    private static boolean isLinux;
    private static boolean isUnix;
    private static boolean isSolaris;
    private static String lineEnder;
    private static boolean bit32;
    private static boolean bit64;
    private static final Runtime.Version JAVA_VERSION;
    private static final String BIT_BUCKET_UNIX = "/dev/null";
    private static final String BIT_BUCKET_WIN = "NUL";
    private static final Logger LOGGER;

    private SystemUtil() {
    }

    public static boolean isWindows() {
        SystemUtil.init();
        return isWindows;
    }

    public static boolean isMac() {
        SystemUtil.init();
        return isMac;
    }

    public static boolean isLinux() {
        SystemUtil.init();
        return isLinux;
    }

    public static boolean isUnix() {
        SystemUtil.init();
        return isUnix;
    }

    public static boolean isSolaris() {
        SystemUtil.init();
        return isSolaris;
    }

    public static String getLineEnder() {
        SystemUtil.init();
        return lineEnder;
    }

    public static boolean is32Bit() {
        SystemUtil.init();
        return bit32;
    }

    public static boolean is64Bit() {
        SystemUtil.init();
        return bit64;
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static String getOsArchitecture() {
        return System.getProperty("os.arch");
    }

    public static String getOsVersion() {
        return System.getProperty("os.version");
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getPathSeparator() {
        return System.getProperty("path.separator");
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    public static Runtime.Version getJavaVersion() {
        return JAVA_VERSION;
    }

    public static String getJavaHome() {
        return System.getProperty("java.home");
    }

    public static String getJavaTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getClassPath() {
        return System.getProperty("java.class.path");
    }

    public static String getLibraryPath() {
        return System.getProperty("java.library.path");
    }

    public static String getBitBucket() {
        if (SystemUtil.isWindows()) {
            return BIT_BUCKET_WIN;
        }
        return BIT_BUCKET_UNIX;
    }

    public static int getCpuCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    private static void init() {
        if (hasInitialized) {
            return;
        }
        String osName = System.getProperty("os.name");
        if (osName != null) {
            String osNameLower = osName.toLowerCase();
            isWindows = osNameLower.contains("windows");
            isMac = osNameLower.contains("mac os x") || osNameLower.contains("darwin");
            isLinux = osNameLower.contains("nux");
            isUnix = osNameLower.contains("nix") || osNameLower.contains("nux");
            isSolaris = osNameLower.contains("sunos") || osNameLower.contains("solaris");
        }
        lineEnder = isWindows ? "\r\n" : "\n";
        String model = System.getProperty("sun.arch.data.model");
        if (StringUtils.isBlank((CharSequence)model)) {
            bit32 = true;
            bit64 = false;
        } else if ("64".equals(model)) {
            bit32 = false;
            bit64 = true;
        } else {
            bit32 = true;
            bit64 = false;
        }
    }

    static {
        JAVA_VERSION = Runtime.version();
        LOGGER = Logger.getLogger(SystemUtil.class);
    }
}

