/*
 * Decompiled with CFR 0.152.
 */
package alpine.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionComparator {
    private final int major;
    private final int minor;
    private final int revision;
    private boolean isSnapshot;
    private int prereleaseNumber;

    public VersionComparator(String version) {
        int[] versions = this.parse(version);
        this.major = versions[0];
        this.minor = versions[1];
        this.revision = versions[2];
        if (versions[3] > 0) {
            this.isSnapshot = true;
            this.prereleaseNumber = versions[3];
        }
    }

    private int[] parse(String version) {
        Matcher m = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)-?(SNAPSHOT)?\\.?(\\d*)?").matcher(version);
        if (!m.matches()) {
            throw new IllegalArgumentException("Malformed version string: " + version);
        }
        return new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)), m.group(4) == null ? 0 : (m.group(5).isEmpty() ? 0 : Integer.parseInt(m.group(5)))};
    }

    public boolean isNewerThan(VersionComparator comparator) {
        if (this.major > comparator.getMajor()) {
            return true;
        }
        if (this.major == comparator.getMajor() && this.minor > comparator.getMinor()) {
            return true;
        }
        if (this.major == comparator.getMajor() && this.minor == comparator.getMinor() && this.revision > comparator.getRevision()) {
            return true;
        }
        return this.major == comparator.getMajor() && this.minor == comparator.getMinor() && this.revision == comparator.getRevision() && this.prereleaseNumber > comparator.getPrereleaseNumber();
    }

    public boolean isOlderThan(VersionComparator comparator) {
        if (this.major < comparator.getMajor()) {
            return true;
        }
        if (this.major == comparator.getMajor() && this.minor < comparator.getMinor()) {
            return true;
        }
        if (this.major == comparator.getMajor() && this.minor == comparator.getMinor() && this.revision < comparator.getRevision()) {
            return true;
        }
        return this.major == comparator.getMajor() && this.minor == comparator.getMinor() && this.revision == comparator.getRevision() && this.prereleaseNumber < comparator.getPrereleaseNumber();
    }

    public boolean equals(Object object) {
        if (object instanceof VersionComparator) {
            VersionComparator comparator = (VersionComparator)object;
            return this.major == comparator.getMajor() && this.minor == comparator.getMinor() && this.revision == comparator.getRevision() && this.isSnapshot == comparator.isSnapshot() && this.prereleaseNumber == comparator.getPrereleaseNumber();
        }
        return false;
    }

    public int hashCode() {
        return 1000 * (this.major + 1) + 100 * (this.minor + 1) + 10 * (this.revision + 1) + (this.prereleaseNumber + 1);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public int getPrereleaseNumber() {
        return this.prereleaseNumber;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append(".").append(this.minor).append(".").append(this.revision);
        if (this.isSnapshot) {
            sb.append("-SNAPSHOT.").append(this.prereleaseNumber);
        }
        return sb.toString();
    }
}

