/*
 * Decompiled with CFR 0.152.
 */
package alpine.auth;

import alpine.auth.AlpineAuthenticationException;
import alpine.auth.OidcConfiguration;
import alpine.auth.OidcProfile;
import alpine.auth.OidcProfileCreator;
import alpine.logging.Logger;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.io.IOException;

class OidcUserInfoAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(OidcUserInfoAuthenticator.class);
    private final OidcConfiguration configuration;

    OidcUserInfoAuthenticator(OidcConfiguration configuration) {
        this.configuration = configuration;
    }

    OidcProfile authenticate(String accessToken, OidcProfileCreator profileCreator) throws AlpineAuthenticationException {
        UserInfoResponse userInfoResponse;
        try {
            HTTPResponse httpResponse = new UserInfoRequest(this.configuration.getUserInfoEndpointUri(), (AccessToken)new BearerAccessToken(accessToken)).toHTTPRequest().send();
            userInfoResponse = UserInfoResponse.parse((HTTPResponse)httpResponse);
        }
        catch (IOException e) {
            LOGGER.error("UserInfo request failed", e);
            throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.OTHER);
        }
        catch (ParseException e) {
            LOGGER.error("Parsing UserInfo response failed", e);
            throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.OTHER);
        }
        if (!userInfoResponse.indicatesSuccess()) {
            ErrorObject error = userInfoResponse.toErrorResponse().getErrorObject();
            LOGGER.error("UserInfo request failed (Code:" + error.getCode() + ", Description: " + error.getDescription() + ")");
            throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.INVALID_CREDENTIALS);
        }
        UserInfo userInfo = userInfoResponse.toSuccessResponse().getUserInfo();
        LOGGER.debug("UserInfo response: " + userInfo.toJSONString());
        return profileCreator.create((ClaimsSet)userInfo);
    }
}

