/*
 * Decompiled with CFR 0.152.
 */
package alpine.crypto;

import alpine.crypto.KeyManager;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class DataEncryption {
    private DataEncryption() {
    }

    public static byte[] encryptAsBytes(SecretKey secretKey, String plainText) throws Exception {
        byte[] clean = plainText.getBytes();
        int ivSize = 16;
        byte[] iv = new byte[ivSize];
        SecureRandom random = new SecureRandom();
        random.nextBytes(iv);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)secretKey, ivParameterSpec);
        byte[] encrypted = cipher.doFinal(clean);
        byte[] encryptedIVAndText = new byte[ivSize + encrypted.length];
        System.arraycopy(iv, 0, encryptedIVAndText, 0, ivSize);
        System.arraycopy(encrypted, 0, encryptedIVAndText, ivSize, encrypted.length);
        return encryptedIVAndText;
    }

    public static byte[] encryptAsBytes(String plainText) throws Exception {
        SecretKey secretKey = KeyManager.getInstance().getSecretKey();
        return DataEncryption.encryptAsBytes(secretKey, plainText);
    }

    public static String encryptAsString(SecretKey secretKey, String plainText) throws Exception {
        return Base64.getEncoder().encodeToString(DataEncryption.encryptAsBytes(secretKey, plainText));
    }

    public static String encryptAsString(String plainText) throws Exception {
        return Base64.getEncoder().encodeToString(DataEncryption.encryptAsBytes(plainText));
    }

    public static byte[] decryptAsBytes(SecretKey secretKey, byte[] encryptedIvTextBytes) throws Exception {
        int ivSize = 16;
        byte[] iv = new byte[ivSize];
        System.arraycopy(encryptedIvTextBytes, 0, iv, 0, iv.length);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        int encryptedSize = encryptedIvTextBytes.length - ivSize;
        byte[] encryptedBytes = new byte[encryptedSize];
        System.arraycopy(encryptedIvTextBytes, ivSize, encryptedBytes, 0, encryptedSize);
        Cipher cipherDecrypt = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipherDecrypt.init(2, (Key)secretKey, ivParameterSpec);
        return cipherDecrypt.doFinal(encryptedBytes);
    }

    public static byte[] decryptAsBytes(byte[] encryptedIvTextBytes) throws Exception {
        SecretKey secretKey = KeyManager.getInstance().getSecretKey();
        return DataEncryption.decryptAsBytes(secretKey, encryptedIvTextBytes);
    }

    public static String decryptAsString(SecretKey secretKey, String encryptedText) throws Exception {
        return new String(DataEncryption.decryptAsBytes(secretKey, Base64.getDecoder().decode(encryptedText)));
    }

    public static String decryptAsString(String encryptedText) throws Exception {
        return new String(DataEncryption.decryptAsBytes(Base64.getDecoder().decode(encryptedText)));
    }
}

