/*
 * Decompiled with CFR 0.152.
 */
package alpine.logging;

import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public final class Logger {
    private final org.slf4j.Logger log;

    public static Logger getLogger(Class<?> clazz) {
        return new Logger(clazz);
    }

    private Logger(Class<?> clazz) {
        this.log = LoggerFactory.getLogger(clazz);
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public void info(String message) {
        this.log.info(this.sanitize(message));
    }

    public void info(String message, Throwable throwable) {
        this.log.info(this.sanitize(message), throwable);
    }

    public void info(Marker marker, String message) {
        this.log.info(marker, this.sanitize(message));
    }

    public void info(Marker marker, String message, Object object) {
        this.log.info(marker, this.sanitize(message), object);
    }

    public void info(Marker marker, String message, Object o1, Object o2) {
        this.log.info(marker, this.sanitize(message), o1, o1);
    }

    public void info(Marker marker, String message, Object ... objects) {
        this.log.info(marker, this.sanitize(message), objects);
    }

    public void info(Marker marker, String message, Throwable throwable) {
        this.log.info(marker, this.sanitize(message), throwable);
    }

    public void debug(String message) {
        this.log.debug(this.sanitize(message));
    }

    public void debug(String message, Throwable throwable) {
        this.log.debug(this.sanitize(message), throwable);
    }

    public void debug(Marker marker, String message) {
        this.log.debug(marker, this.sanitize(message));
    }

    public void debug(Marker marker, String message, Object object) {
        this.log.debug(marker, this.sanitize(message), object);
    }

    public void debug(Marker marker, String message, Object o1, Object o2) {
        this.log.debug(marker, this.sanitize(message), o1, o1);
    }

    public void debug(Marker marker, String message, Object ... objects) {
        this.log.debug(marker, this.sanitize(message), objects);
    }

    public void debug(Marker marker, String message, Throwable throwable) {
        this.log.debug(marker, this.sanitize(message), throwable);
    }

    public void error(String message) {
        this.log.error(this.sanitize(message));
    }

    public void error(String message, Throwable throwable) {
        this.log.error(this.sanitize(message), throwable);
    }

    public void error(Marker marker, String message) {
        this.log.error(marker, this.sanitize(message));
    }

    public void error(Marker marker, String message, Object object) {
        this.log.error(marker, this.sanitize(message), object);
    }

    public void error(Marker marker, String message, Object o1, Object o2) {
        this.log.error(marker, this.sanitize(message), o1, o1);
    }

    public void error(Marker marker, String message, Object ... objects) {
        this.log.error(marker, this.sanitize(message), objects);
    }

    public void error(Marker marker, String message, Throwable throwable) {
        this.log.error(marker, this.sanitize(message), throwable);
    }

    public void trace(String message) {
        this.log.trace(this.sanitize(message));
    }

    public void trace(String message, Throwable throwable) {
        this.log.trace(this.sanitize(message), throwable);
    }

    public void trace(Marker marker, String message) {
        this.log.trace(marker, this.sanitize(message));
    }

    public void trace(Marker marker, String message, Object object) {
        this.log.trace(marker, this.sanitize(message), object);
    }

    public void trace(Marker marker, String message, Object o1, Object o2) {
        this.log.trace(marker, this.sanitize(message), o1, o1);
    }

    public void trace(Marker marker, String message, Object ... objects) {
        this.log.trace(marker, this.sanitize(message), objects);
    }

    public void trace(Marker marker, String message, Throwable throwable) {
        this.log.trace(marker, this.sanitize(message), throwable);
    }

    public void warn(String message) {
        this.log.warn(this.sanitize(message));
    }

    public void warn(String message, Throwable throwable) {
        this.log.warn(this.sanitize(message), throwable);
    }

    public void warn(Marker marker, String message) {
        this.log.warn(marker, this.sanitize(message));
    }

    public void warn(Marker marker, String message, Object object) {
        this.log.warn(marker, this.sanitize(message), object);
    }

    public void warn(Marker marker, String message, Object o1, Object o2) {
        this.log.warn(marker, this.sanitize(message), o1, o1);
    }

    public void warn(Marker marker, String message, Object ... objects) {
        this.log.warn(marker, this.sanitize(message), objects);
    }

    public void warn(Marker marker, String message, Throwable throwable) {
        this.log.warn(marker, this.sanitize(message), throwable);
    }

    private String sanitize(String message) {
        return message.replaceAll("[\r\n]", "");
    }
}

