/*
 * Decompiled with CFR 0.152.
 */
package alpine.notification;

import alpine.event.framework.LoggableUncaughtExceptionHandler;
import alpine.logging.Logger;
import alpine.notification.INotificationService;
import alpine.notification.Notification;
import alpine.notification.Subscriber;
import alpine.notification.Subscription;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;

public final class NotificationService
implements INotificationService {
    private static final NotificationService INSTANCE = new NotificationService();
    private static final Logger LOGGER = Logger.getLogger(NotificationService.class);
    private static final Map<Class<? extends Notification>, ArrayList<Subscription>> SUBSCRIPTION_MAP = new ConcurrentHashMap<Class<? extends Notification>, ArrayList<Subscription>>();
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(4, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("Alpine-NotificationService-%d").uncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new LoggableUncaughtExceptionHandler()).build());

    private NotificationService() {
    }

    public static NotificationService getInstance() {
        return INSTANCE;
    }

    @Override
    public void publish(Notification notification) {
        LOGGER.debug("Dispatching notification: " + notification.getClass().toString());
        ArrayList<Subscription> subscriptions = SUBSCRIPTION_MAP.get(notification.getClass());
        if (subscriptions == null) {
            LOGGER.debug("No subscribers to inform from notification: " + notification.getClass().getName());
            return;
        }
        for (Subscription subscription : subscriptions) {
            if (subscription.getScope() != null && subscription.getGroup() != null && subscription.getLevel() != null) {
                if (!subscription.getScope().equals(notification.getScope()) || !subscription.getGroup().equals(notification.getGroup()) || subscription.getLevel() != notification.getLevel()) continue;
                this.alertSubscriber(notification, subscription.getSubscriber());
                continue;
            }
            if (subscription.getGroup() != null && subscription.getLevel() != null) {
                if (!subscription.getGroup().equals(notification.getGroup()) || subscription.getLevel() != notification.getLevel()) continue;
                this.alertSubscriber(notification, subscription.getSubscriber());
                continue;
            }
            if (subscription.getGroup() != null) {
                if (!subscription.getGroup().equals(notification.getGroup())) continue;
                this.alertSubscriber(notification, subscription.getSubscriber());
                continue;
            }
            if (subscription.getLevel() != null) {
                if (subscription.getLevel() != notification.getLevel()) continue;
                this.alertSubscriber(notification, subscription.getSubscriber());
                continue;
            }
            this.alertSubscriber(notification, subscription.getSubscriber());
        }
    }

    private void alertSubscriber(Notification notification, Class<? extends Subscriber> subscriberClass) {
        LOGGER.debug("Alerting subscriber " + subscriberClass.getName());
        EXECUTOR_SERVICE.execute(() -> {
            try {
                ((Subscriber)subscriberClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).inform(notification);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.error("An error occurred while informing subscriber: " + e);
            }
        });
    }

    @Override
    public void subscribe(Class<? extends Notification> notificationClass, Subscription subscription) {
        ArrayList<Subscription> subscriptions;
        if (!SUBSCRIPTION_MAP.containsKey(notificationClass)) {
            SUBSCRIPTION_MAP.put(notificationClass, new ArrayList());
        }
        if (!(subscriptions = SUBSCRIPTION_MAP.get(notificationClass)).contains(subscription)) {
            subscriptions.add(subscription);
        }
    }

    @Override
    public void subscribe(Subscription subscription) {
        this.subscribe(Notification.class, subscription);
    }

    @Override
    public void unsubscribe(Subscription subscription) {
        for (ArrayList<Subscription> list : SUBSCRIPTION_MAP.values()) {
            list.remove(subscription);
        }
    }

    @Override
    public boolean hasSubscriptions(Notification notification) {
        ArrayList<Subscription> subscriptions = SUBSCRIPTION_MAP.get(notification.getClass());
        return subscriptions != null;
    }

    @Override
    public void shutdown() {
        LOGGER.info("Shutting down NotificationService");
        EXECUTOR_SERVICE.shutdown();
    }
}

