/*
 * Decompiled with CFR 0.152.
 */
package alpine.validation;

import java.nio.charset.StandardCharsets;

public class LdapStringSanitizer {
    private LdapStringSanitizer() {
    }

    public static String sanitize(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            byte[] utf8bytes;
            char c = input.charAt(i);
            if (c == '*') {
                sb.append("\\2a");
                continue;
            }
            if (c == '(') {
                sb.append("\\28");
                continue;
            }
            if (c == ')') {
                sb.append("\\29");
                continue;
            }
            if (c == '\\') {
                sb.append("\\5c");
                continue;
            }
            if (c == '\u0000') {
                sb.append("\\00");
                continue;
            }
            if (c <= '\u007f') {
                sb.append(String.valueOf(c));
                continue;
            }
            if (c < '\u0080') continue;
            for (byte b : utf8bytes = String.valueOf(c).getBytes(StandardCharsets.UTF_8)) {
                sb.append(String.format("\\%02x", b));
            }
        }
        return sb.toString();
    }
}

