package alpine.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;

import javax.jdo.annotations.Column;
import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;
import javax.jdo.annotations.Unique;
import javax.validation.constraints.NotNull;
import java.util.UUID;

/**
 * Persistable object representing a OpenID Connect group mapped to a Team.
 *
 * @since 1.8.0
 */
@PersistenceCapable
@JsonInclude(JsonInclude.Include.NON_NULL)
@Unique(members = {"team", "group"})
public class MappedOidcGroup {

    @PrimaryKey
    @Persistent(valueStrategy = IdGeneratorStrategy.NATIVE)
    @JsonIgnore
    private long id;

    @Persistent(defaultFetchGroup = "true")
    @Column(name = "TEAM_ID", allowsNull = "false")
    @JsonIgnore
    private Team team;

    @Persistent(defaultFetchGroup = "true")
    @Column(name = "GROUP_ID", allowsNull = "false")
    private OidcGroup group;

    @Persistent(customValueStrategy = "uuid")
    @Unique(name = "MAPPEDOIDCGROUP_UUID_IDX")
    @Column(name = "UUID", jdbcType = "VARCHAR", length = 36, allowsNull = "false")
    @NotNull
    private UUID uuid;

    public long getId() {
        return id;
    }

    public void setId(final long id) {
        this.id = id;
    }

    public Team getTeam() {
        return team;
    }

    public void setTeam(final Team team) {
        this.team = team;
    }

    public OidcGroup getGroup() {
        return group;
    }

    public void setGroup(final OidcGroup group) {
        this.group = group;
    }

    public UUID getUuid() {
        return uuid;
    }

    public void setUuid(final UUID uuid) {
        this.uuid = uuid;
    }

}
