/*
 * Decompiled with CFR 0.152.
 */
package alpine.auth;

import alpine.Config;
import alpine.auth.IdentityProvider;
import alpine.crypto.KeyManager;
import alpine.logging.Logger;
import alpine.model.LdapUser;
import alpine.model.OidcUser;
import alpine.model.Permission;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.security.Key;
import java.security.Principal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import org.owasp.security.logging.SecurityMarkers;

public class JsonWebToken {
    private static final Logger LOGGER = Logger.getLogger(JsonWebToken.class);
    private static final String IDENTITY_PROVIDER_CLAIM = "idp";
    private static String ISSUER = "Alpine";
    private final Key key;
    private String subject;
    private Date expiration;
    private IdentityProvider identityProvider;

    public JsonWebToken(SecretKey key) {
        this.key = key;
    }

    public JsonWebToken() {
        this.key = KeyManager.getInstance().getSecretKey();
    }

    public String createToken(Principal principal) {
        return this.createToken(principal, null);
    }

    public String createToken(Principal principal, List<Permission> permissions) {
        return this.createToken(principal, permissions, null);
    }

    public String createToken(Principal principal, List<Permission> permissions, IdentityProvider identityProvider) {
        Date today = new Date();
        JwtBuilder jwtBuilder = Jwts.builder();
        jwtBuilder.setSubject(principal.getName());
        jwtBuilder.setIssuer(ISSUER);
        jwtBuilder.setIssuedAt(today);
        jwtBuilder.setExpiration(this.addDays(today, 7));
        if (permissions != null) {
            jwtBuilder.claim("permissions", (Object)permissions.stream().map(Permission::getName).collect(Collectors.joining(",")));
        }
        if (identityProvider != null) {
            jwtBuilder.claim(IDENTITY_PROVIDER_CLAIM, (Object)identityProvider.name());
        } else if (principal instanceof LdapUser) {
            jwtBuilder.claim(IDENTITY_PROVIDER_CLAIM, (Object)IdentityProvider.LDAP.name());
        } else if (principal instanceof OidcUser) {
            jwtBuilder.claim(IDENTITY_PROVIDER_CLAIM, (Object)IdentityProvider.OPENID_CONNECT.name());
        } else {
            jwtBuilder.claim(IDENTITY_PROVIDER_CLAIM, (Object)IdentityProvider.LOCAL.name());
        }
        return jwtBuilder.signWith(SignatureAlgorithm.HS256, this.key).compact();
    }

    public String createToken(Map<String, Object> claims) {
        JwtBuilder jwtBuilder = Jwts.builder();
        jwtBuilder.setClaims(claims);
        return jwtBuilder.signWith(SignatureAlgorithm.HS256, this.key).compact();
    }

    public boolean validateToken(String token) {
        try {
            JwtParser jwtParser = Jwts.parser().setSigningKey(this.key);
            Jws claims = jwtParser.parseClaimsJws(token);
            this.subject = ((Claims)claims.getBody()).getSubject();
            this.expiration = ((Claims)claims.getBody()).getExpiration();
            this.identityProvider = IdentityProvider.forName((String)((Claims)claims.getBody()).get(IDENTITY_PROVIDER_CLAIM, String.class));
            return true;
        }
        catch (SignatureException e) {
            LOGGER.info(SecurityMarkers.SECURITY_FAILURE, "Received token that did not pass signature verification");
        }
        catch (ExpiredJwtException e) {
            LOGGER.debug(SecurityMarkers.SECURITY_FAILURE, "Received expired token");
        }
        catch (MalformedJwtException e) {
            LOGGER.debug(SecurityMarkers.SECURITY_FAILURE, "Received malformed token");
            LOGGER.debug(SecurityMarkers.SECURITY_FAILURE, e.getMessage());
        }
        catch (UnsupportedJwtException | IllegalArgumentException e) {
            LOGGER.error(SecurityMarkers.SECURITY_FAILURE, e.getMessage());
        }
        return false;
    }

    private Date addDays(Date date, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return cal.getTime();
    }

    public String getSubject() {
        return this.subject;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public IdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    static {
        if (Config.getInstance().getApplicationName() != null) {
            ISSUER = Config.getInstance().getApplicationName();
        } else {
            Config.getInstance().getFrameworkName();
        }
    }
}

