/*
 * Decompiled with CFR 0.152.
 */
package alpine.auth;

import alpine.Config;
import alpine.auth.AlpineAuthenticationException;
import alpine.auth.AuthenticationService;
import alpine.auth.OidcConfiguration;
import alpine.auth.OidcConfigurationResolver;
import alpine.auth.OidcUserInfo;
import alpine.logging.Logger;
import alpine.model.OidcUser;
import alpine.persistence.AlpineQueryManager;
import alpine.util.OidcUtil;
import java.security.Principal;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientBuilder;

public class OidcAuthenticationService
implements AuthenticationService {
    private static final Logger LOGGER = Logger.getLogger(OidcAuthenticationService.class);
    private final Config config;
    private final OidcConfiguration oidcConfiguration;
    private final String accessToken;

    public OidcAuthenticationService(String accessToken) {
        this(Config.getInstance(), OidcConfigurationResolver.getInstance().resolve(), accessToken);
    }

    OidcAuthenticationService(Config config, OidcConfiguration oidcConfiguration, String accessToken) {
        this.config = config;
        this.oidcConfiguration = oidcConfiguration;
        this.accessToken = accessToken;
    }

    @Override
    public boolean isSpecified() {
        return OidcUtil.isOidcAvailable(this.config, this.oidcConfiguration) && this.accessToken != null;
    }

    @Override
    @Nullable
    public Principal authenticate() throws AlpineAuthenticationException {
        OidcUserInfo userInfo;
        try {
            userInfo = (OidcUserInfo)ClientBuilder.newClient().target(this.oidcConfiguration.getUserInfoEndpointUri()).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.accessToken)).get(OidcUserInfo.class);
        }
        catch (WebApplicationException e) {
            if (e.getResponse().getStatus() == 401) {
                throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.INVALID_CREDENTIALS);
            }
            LOGGER.error("An error occurred requesting the OIDC UserInfo", e);
            throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.OTHER);
        }
        catch (ProcessingException e) {
            LOGGER.error("An error occurred while processing the OIDC UserInfo response", e);
            throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.OTHER);
        }
        String usernameClaim = this.config.getProperty(Config.AlpineKey.OIDC_USERNAME_CLAIM);
        String username = userInfo.getClaim(usernameClaim, String.class);
        if (username == null) {
            LOGGER.error("The configured OIDC username claim (" + usernameClaim + ") could not be found in UserInfo response");
            LOGGER.debug("Claims returned in UserInfo response: " + userInfo.getClaims());
            throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.OTHER);
        }
        try (AlpineQueryManager qm = new AlpineQueryManager();){
            OidcUser user = qm.getOidcUser(username);
            if (user != null) {
                LOGGER.debug("Attempting to authenticate user: " + username);
                user.setEmail(userInfo.getEmail());
                if (user.getSubjectIdentifier() == null) {
                    LOGGER.debug("Assigning subject identifier " + userInfo.getSubject() + " to user " + username);
                    user.setSubjectIdentifier(userInfo.getSubject());
                    OidcUser oidcUser = qm.updateOidcUser(user);
                    return oidcUser;
                }
                if (!user.getSubjectIdentifier().equals(userInfo.getSubject())) {
                    LOGGER.error("Refusing to authenticate user " + username + ": subject identifier has changed (" + user.getSubjectIdentifier() + " to " + userInfo.getSubject() + ")");
                    throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.INVALID_CREDENTIALS);
                }
                if (this.config.getPropertyAsBoolean(Config.AlpineKey.OIDC_TEAM_SYNCHRONIZATION)) {
                    OidcUser oidcUser = this.synchronizeTeams(qm, user, userInfo);
                    return oidcUser;
                }
                OidcUser oidcUser = user;
                return oidcUser;
            }
            if (this.config.getPropertyAsBoolean(Config.AlpineKey.OIDC_USER_PROVISIONING)) {
                LOGGER.debug("The user (" + username + ") authenticated successfully but the account has not been provisioned");
                OidcUser oidcUser = this.autoProvision(qm, username, userInfo);
                return oidcUser;
            }
            LOGGER.debug("The user (" + username + ") is unmapped and user provisioning is not enabled");
            throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.UNMAPPED_ACCOUNT);
        }
    }

    private OidcUser autoProvision(AlpineQueryManager qm, String username, OidcUserInfo userInfo) {
        OidcUser user = new OidcUser();
        user.setUsername(username);
        user.setSubjectIdentifier(userInfo.getSubject());
        user.setEmail(userInfo.getEmail());
        user = qm.persist(user);
        if (this.config.getPropertyAsBoolean(Config.AlpineKey.OIDC_TEAM_SYNCHRONIZATION)) {
            LOGGER.debug("Synchronizing teams for user " + username);
            return this.synchronizeTeams(qm, user, userInfo);
        }
        return user;
    }

    OidcUser synchronizeTeams(AlpineQueryManager qm, OidcUser user, OidcUserInfo userInfo) {
        List groups;
        String teamsClaim = this.config.getProperty(Config.AlpineKey.OIDC_TEAMS_CLAIM);
        if (teamsClaim == null) {
            LOGGER.error("Synchronizing teams for user " + user.getUsername() + " failed: Synchronization is enabled, but no teams claim is configured");
            return user;
        }
        try {
            groups = userInfo.getClaim(teamsClaim, List.class);
        }
        catch (ClassCastException e) {
            LOGGER.error("Synchronizing teams for user " + user.getUsername() + " failed: Teams claim is not a list", e);
            return user;
        }
        if (groups == null) {
            LOGGER.error("Synchronizing teams for user " + user.getUsername() + " failed: Teams claim " + teamsClaim + " does not exist");
            return user;
        }
        return qm.synchronizeTeamMembership(user, (List<String>)groups);
    }
}

