/*
 * Decompiled with CFR 0.152.
 */
package alpine.auth;

import alpine.Config;
import alpine.auth.OidcConfiguration;
import alpine.cache.CacheManager;
import alpine.logging.Logger;
import javax.annotation.Nullable;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientBuilder;

public class OidcConfigurationResolver {
    private static final OidcConfigurationResolver INSTANCE = new OidcConfigurationResolver(Config.getInstance().getPropertyAsBoolean(Config.AlpineKey.OIDC_ENABLED), Config.getInstance().getProperty(Config.AlpineKey.OIDC_ISSUER));
    private static final Logger LOGGER = Logger.getLogger(OidcConfigurationResolver.class);
    static final String OPENID_CONFIGURATION_PATH = "/.well-known/openid-configuration";
    static final String CONFIGURATION_CACHE_KEY = "OIDC_CONFIGURATION";
    private final boolean oidcEnabled;
    private final String issuer;

    OidcConfigurationResolver(boolean oidcEnabled, String issuer) {
        this.oidcEnabled = oidcEnabled;
        this.issuer = issuer;
    }

    public static OidcConfigurationResolver getInstance() {
        return INSTANCE;
    }

    @Nullable
    public OidcConfiguration resolve() {
        if (!this.oidcEnabled) {
            LOGGER.debug("Will not resolve OIDC configuration: OIDC is disabled");
            return null;
        }
        if (this.issuer == null) {
            LOGGER.error("Cannot resolve OIDC configuration: No issuer provided");
            return null;
        }
        OidcConfiguration configuration = (OidcConfiguration)CacheManager.getInstance().get(OidcConfiguration.class, CONFIGURATION_CACHE_KEY);
        if (configuration != null) {
            LOGGER.debug("OIDC configuration loaded from cache");
            return configuration;
        }
        LOGGER.debug("Loading OIDC configuration for issuer " + this.issuer);
        try {
            configuration = (OidcConfiguration)ClientBuilder.newClient().target(this.issuer).path(OPENID_CONFIGURATION_PATH).request(new String[]{"application/json"}).get(OidcConfiguration.class);
        }
        catch (ProcessingException | WebApplicationException e) {
            LOGGER.error("Failed to load OIDC configuration from issuer " + this.issuer + ": " + e.getMessage());
            return null;
        }
        LOGGER.debug("Storing OIDC configuration in cache");
        CacheManager.getInstance().put(CONFIGURATION_CACHE_KEY, configuration);
        return configuration;
    }
}

