/*
 * Decompiled with CFR 0.152.
 */
package alpine.event.framework;

import alpine.event.framework.ChainableEvent;
import alpine.event.framework.EventService;
import alpine.event.framework.SingleThreadedEventService;
import alpine.logging.Logger;
import java.util.UUID;

public interface Event {
    public static void dispatch(Event event) {
        boolean informed = false;
        if (EventService.getInstance().hasSubscriptions(event)) {
            informed = true;
            EventService.getInstance().publish(event);
        }
        if (SingleThreadedEventService.getInstance().hasSubscriptions(event)) {
            informed = true;
            SingleThreadedEventService.getInstance().publish(event);
        }
        if (!informed) {
            Logger.getLogger(Event.class).debug("No subscribers to inform from event: " + event.getClass().getName());
        }
    }

    public static boolean isEventBeingProcessed(ChainableEvent event) {
        return Event.isEventBeingProcessed(event.getChainIdentifier());
    }

    public static boolean isEventBeingProcessed(UUID chainIdentifier) {
        if (EventService.getInstance().isEventBeingProcessed(chainIdentifier)) {
            return true;
        }
        return SingleThreadedEventService.getInstance().isEventBeingProcessed(chainIdentifier);
    }
}

