/*
 * Decompiled with CFR 0.152.
 */
package alpine.filters;

import alpine.util.BooleanUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class HpkpFilter
implements Filter {
    private static final long DEFAULT_MAX_AGE = 15768000L;
    private String primaryHash = null;
    private String backupHash = null;
    private long maxAge = 15768000L;
    private boolean includeSubdomains = false;
    private String reportUri;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.primaryHash = filterConfig.getInitParameter("primaryHash");
        this.backupHash = filterConfig.getInitParameter("backupHash");
        String maxAgeString = filterConfig.getInitParameter("maxAge");
        try {
            this.maxAge = Long.valueOf(maxAgeString);
        }
        catch (NumberFormatException e) {
            this.maxAge = 15768000L;
        }
        this.includeSubdomains = BooleanUtil.valueOf(filterConfig.getInitParameter("includeSubdomains"));
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        if (request.isSecure()) {
            response.setHeader("Public-Key-Pins", this.formatPolicy());
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String formatPolicy() {
        StringBuilder sb = new StringBuilder();
        sb.append("pin-sha256").append("=\"").append(this.primaryHash).append("\"; ");
        sb.append("pin-sha256").append("=\"").append(this.backupHash).append("\"; ");
        sb.append("max-age").append("=").append(this.maxAge);
        if (this.includeSubdomains) {
            sb.append("; ").append("includeSubDomains");
        }
        if (this.reportUri != null) {
            sb.append("; ").append("report-uri").append("=\"").append(this.reportUri).append("\"");
        }
        return sb.toString();
    }

    public void destroy() {
    }
}

