/*
 * Decompiled with CFR 0.152.
 */
package alpine.persistence;

import alpine.persistence.PaginatedResult;
import alpine.persistence.PersistenceManagerFactory;
import alpine.resources.AlpineRequest;
import alpine.resources.OrderDirection;
import alpine.resources.Pagination;
import alpine.validation.RegexSequence;
import io.jsonwebtoken.lang.Collections;
import java.lang.reflect.Field;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jdo.PersistenceManager;
import org.apache.commons.collections4.CollectionUtils;
import org.datanucleus.api.jdo.JDOQuery;
import org.datanucleus.store.query.Query;

public abstract class AbstractAlpineQueryManager
implements AutoCloseable {
    protected final Principal principal;
    protected Pagination pagination;
    protected final String filter;
    protected final String orderBy;
    protected final OrderDirection orderDirection;
    protected final PersistenceManager pm;

    public AbstractAlpineQueryManager(PersistenceManager pm) {
        this.pm = pm;
        this.principal = null;
        this.pagination = new Pagination(Pagination.Strategy.NONE, 0, 0);
        this.filter = null;
        this.orderBy = null;
        this.orderDirection = OrderDirection.UNSPECIFIED;
    }

    public AbstractAlpineQueryManager() {
        this.pm = PersistenceManagerFactory.createPersistenceManager();
        this.principal = null;
        this.pagination = new Pagination(Pagination.Strategy.NONE, 0, 0);
        this.filter = null;
        this.orderBy = null;
        this.orderDirection = OrderDirection.UNSPECIFIED;
    }

    public AbstractAlpineQueryManager(Principal principal, Pagination pagination, String filter, String orderBy, OrderDirection orderDirection) {
        this.pm = PersistenceManagerFactory.createPersistenceManager();
        this.principal = principal;
        this.pagination = pagination;
        this.filter = filter;
        this.orderBy = orderBy;
        this.orderDirection = orderDirection;
    }

    public AbstractAlpineQueryManager(AlpineRequest request) {
        this.pm = PersistenceManagerFactory.createPersistenceManager();
        this.principal = request.getPrincipal();
        this.pagination = request.getPagination();
        this.filter = request.getFilter();
        this.orderBy = request.getOrderBy();
        this.orderDirection = request.getOrderDirection();
    }

    public PaginatedResult execute(javax.jdo.Query query) {
        long count = this.getCount(query);
        this.decorate(query);
        return new PaginatedResult().objects(query.execute()).total(count);
    }

    public PaginatedResult execute(javax.jdo.Query query, Object p1) {
        long count = this.getCount(query, p1);
        this.decorate(query);
        return new PaginatedResult().objects(query.execute(p1)).total(count);
    }

    public PaginatedResult execute(javax.jdo.Query query, Object p1, Object p2) {
        long count = this.getCount(query, p1, p2);
        this.decorate(query);
        return new PaginatedResult().objects(query.execute(p1, p2)).total(count);
    }

    public PaginatedResult execute(javax.jdo.Query query, Object p1, Object p2, Object p3) {
        long count = this.getCount(query, p1, p2, p3);
        this.decorate(query);
        return new PaginatedResult().objects(query.execute(p1, p2, p3)).total(count);
    }

    public PaginatedResult execute(javax.jdo.Query query, Object ... parameters) {
        long count = this.getCount(query, parameters);
        this.decorate(query);
        return new PaginatedResult().objects(query.executeWithArray(parameters)).total(count);
    }

    public PaginatedResult execute(javax.jdo.Query query, Map parameters) {
        long count = this.getCount(query, parameters);
        this.decorate(query);
        return new PaginatedResult().objects(query.executeWithMap(parameters)).total(count);
    }

    public void advancePagination() {
        if (this.pagination.isPaginated()) {
            this.pagination = new Pagination(this.pagination.getStrategy(), this.pagination.getOffset() + this.pagination.getLimit(), this.pagination.getLimit());
        }
    }

    public javax.jdo.Query decorate(javax.jdo.Query query) {
        query.setResult(null);
        if (this.pagination != null && this.pagination.isPaginated()) {
            long begin = this.pagination.getOffset();
            long end = begin + (long)this.pagination.getLimit();
            query.setRange(begin, end);
        }
        if (this.orderBy != null && RegexSequence.Pattern.STRING_IDENTIFIER.matcher(this.orderBy).matches() && this.orderDirection != OrderDirection.UNSPECIFIED) {
            boolean found = false;
            Query iq = ((JDOQuery)query).getInternalQuery();
            String candidateField = this.orderBy.contains(".") ? this.orderBy.substring(0, this.orderBy.indexOf(46)) : this.orderBy;
            for (Field field : iq.getCandidateClass().getDeclaredFields()) {
                if (!candidateField.equals(field.getName())) continue;
                found = true;
                break;
            }
            if (found) {
                query.setOrdering(this.orderBy + " " + this.orderDirection.name().toLowerCase());
            }
        }
        return query;
    }

    public long getCount(javax.jdo.Query query) {
        String ordering = ((JDOQuery)query).getInternalQuery().getOrdering();
        query.setResult("count(id)");
        query.setOrdering(null);
        long count = (Long)query.execute();
        query.setOrdering(ordering);
        return count;
    }

    public long getCount(javax.jdo.Query query, Object p1) {
        String ordering = ((JDOQuery)query).getInternalQuery().getOrdering();
        query.setResult("count(id)");
        query.setOrdering(null);
        long count = (Long)query.execute(p1);
        query.setOrdering(ordering);
        return count;
    }

    public long getCount(javax.jdo.Query query, Object p1, Object p2) {
        String ordering = ((JDOQuery)query).getInternalQuery().getOrdering();
        query.setResult("count(id)");
        query.setOrdering(null);
        long count = (Long)query.execute(p1, p2);
        query.setOrdering(ordering);
        return count;
    }

    public long getCount(javax.jdo.Query query, Object p1, Object p2, Object p3) {
        String ordering = ((JDOQuery)query).getInternalQuery().getOrdering();
        query.setResult("count(id)");
        query.setOrdering(null);
        long count = (Long)query.execute(p1, p2, p3);
        query.setOrdering(ordering);
        return count;
    }

    public long getCount(javax.jdo.Query query, Object ... parameters) {
        String ordering = ((JDOQuery)query).getInternalQuery().getOrdering();
        query.setResult("count(id)");
        query.setOrdering(null);
        long count = (Long)query.executeWithArray(parameters);
        query.setOrdering(ordering);
        return count;
    }

    public long getCount(javax.jdo.Query query, Map parameters) {
        String ordering = ((JDOQuery)query).getInternalQuery().getOrdering();
        query.setResult("count(id)");
        query.setOrdering(null);
        long count = (Long)query.executeWithMap(parameters);
        query.setOrdering(ordering);
        return count;
    }

    public <T> long getCount(Class<T> cls) {
        javax.jdo.Query query = this.pm.newQuery(cls);
        query.setResult("count(id)");
        return (Long)query.execute();
    }

    public <T> T persist(T object) {
        this.pm.currentTransaction().begin();
        this.pm.makePersistent(object);
        this.pm.currentTransaction().commit();
        this.pm.getFetchPlan().setDetachmentOptions(1);
        this.pm.refresh(object);
        return object;
    }

    public <T> T[] persist(T ... pcs) {
        this.pm.currentTransaction().begin();
        this.pm.makePersistentAll((Object[])pcs);
        this.pm.currentTransaction().commit();
        this.pm.getFetchPlan().setDetachmentOptions(1);
        this.pm.refreshAll((Object[])pcs);
        return pcs;
    }

    public <T> Collection<T> persist(Collection pcs) {
        this.pm.currentTransaction().begin();
        this.pm.makePersistentAll(pcs);
        this.pm.currentTransaction().commit();
        this.pm.getFetchPlan().setDetachmentOptions(1);
        this.pm.refreshAll(pcs);
        return pcs;
    }

    public void delete(Object ... objects) {
        this.pm.currentTransaction().begin();
        this.pm.deletePersistentAll(objects);
        this.pm.currentTransaction().commit();
    }

    public void delete(Collection collection) {
        this.pm.currentTransaction().begin();
        this.pm.deletePersistentAll(collection);
        this.pm.currentTransaction().commit();
    }

    public <T> T detach(Class<T> clazz, Object id) {
        this.pm.getFetchPlan().setDetachmentOptions(1);
        return (T)this.pm.detachCopy(this.pm.getObjectById(clazz, id));
    }

    public <T> List<T> detach(List<T> pcs) {
        this.pm.getFetchPlan().setDetachmentOptions(1);
        return new ArrayList(this.pm.detachCopyAll(pcs));
    }

    public <T> Set<T> detach(Set<T> pcs) {
        this.pm.getFetchPlan().setDetachmentOptions(1);
        return new LinkedHashSet(this.pm.detachCopyAll(pcs));
    }

    public <T> T getObjectById(Class<T> clazz, Object id) {
        return (T)this.pm.getObjectById(clazz, id);
    }

    public <T> T getObjectByUuid(Class<T> clazz, UUID uuid) {
        javax.jdo.Query query = this.pm.newQuery(clazz, "uuid == :uuid");
        List result = (List)query.execute((Object)uuid);
        return Collections.isEmpty((Collection)result) ? null : (T)result.get(0);
    }

    public <T> T getObjectByUuid(Class<T> clazz, String uuid) {
        return this.getObjectByUuid(clazz, UUID.fromString(uuid));
    }

    public <T> T getObjectByUuid(Class<T> clazz, UUID uuid, String fetchGroup) {
        this.pm.getFetchPlan().addGroup(fetchGroup);
        return this.getObjectByUuid(clazz, uuid);
    }

    public <T> T getObjectByUuid(Class<T> clazz, String uuid, String fetchGroup) {
        return this.getObjectByUuid(clazz, UUID.fromString(uuid), fetchGroup);
    }

    public <T> T singleResult(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Collection) {
            Collection result = (Collection)object;
            return CollectionUtils.isEmpty((Collection)result) ? null : (T)result.iterator().next();
        }
        return null;
    }

    @Override
    public void close() {
        this.pm.close();
    }

    public PersistenceManager getPersistenceManager() {
        return this.pm;
    }
}

