/*
 * Decompiled with CFR 0.152.
 */
package alpine.persistence;

import alpine.Config;
import java.util.Properties;

public final class JdoProperties {
    private JdoProperties() {
    }

    public static Properties get() {
        Properties properties = new Properties();
        properties.put("javax.jdo.option.ConnectionURL", Config.getInstance().getProperty(Config.AlpineKey.DATABASE_URL));
        properties.put("javax.jdo.option.ConnectionDriverName", Config.getInstance().getProperty(Config.AlpineKey.DATABASE_DRIVER));
        properties.put("javax.jdo.option.ConnectionUserName", Config.getInstance().getProperty(Config.AlpineKey.DATABASE_USERNAME));
        properties.put("javax.jdo.option.ConnectionPassword", Config.getInstance().getPropertyOrFile(Config.AlpineKey.DATABASE_PASSWORD));
        if (Config.getInstance().getPropertyAsBoolean(Config.AlpineKey.DATABASE_POOL_ENABLED)) {
            properties.put("datanucleus.connectionPoolingType", "HikariCP");
            properties.put("datanucleus.connectionPool.maxPoolSize", Config.getInstance().getProperty(Config.AlpineKey.DATABASE_POOL_MAX_SIZE));
            properties.put("datanucleus.connectionPool.idleTimeout", Config.getInstance().getProperty(Config.AlpineKey.DATABASE_POOL_IDLE_TIMEOUT));
            properties.put("datanucleus.connectionPool.maxLifetime", Config.getInstance().getProperty(Config.AlpineKey.DATABASE_POOL_MAX_LIFETIME));
        }
        properties.put("datanucleus.schema.autoCreateDatabase", "true");
        properties.put("datanucleus.schema.autoCreateTables", "true");
        properties.put("datanucleus.schema.autoCreateColumns", "true");
        properties.put("datanucleus.schema.autoCreateConstraints", "true");
        properties.put("datanucleus.generateSchema.database.mode", "create");
        properties.put("datanucleus.query.jdoql.allowAll", "true");
        return properties;
    }

    public static Properties unit() {
        Properties properties = new Properties();
        properties.put("javax.jdo.option.PersistenceUnitName", "Alpine");
        properties.put("javax.jdo.option.ConnectionURL", "jdbc:h2:mem:alpine");
        properties.put("javax.jdo.option.ConnectionDriverName", "org.h2.Driver");
        properties.put("javax.jdo.option.ConnectionUserName", "sa");
        properties.put("javax.jdo.option.ConnectionPassword", "");
        properties.put("javax.jdo.option.Mapping", "h2");
        properties.put("datanucleus.schema.autoCreateDatabase", "true");
        properties.put("datanucleus.schema.autoCreateTables", "true");
        properties.put("datanucleus.schema.autoCreateColumns", "true");
        properties.put("datanucleus.schema.autoCreateConstraints", "true");
        properties.put("datanucleus.generateSchema.database.mode", "create");
        properties.put("datanucleus.query.jdoql.allowAll", "true");
        return properties;
    }
}

