/*
 * Decompiled with CFR 0.152.
 */
package alpine.resources;

import alpine.logging.Logger;
import alpine.model.ApiKey;
import alpine.model.LdapUser;
import alpine.model.ManagedUser;
import alpine.model.OidcUser;
import alpine.model.UserPrincipal;
import alpine.persistence.AlpineQueryManager;
import alpine.resources.AlpineRequest;
import alpine.resources.OrderDirection;
import alpine.resources.Pagination;
import alpine.validation.RegexSequence;
import alpine.validation.ValidationException;
import alpine.validation.ValidationTask;
import io.jsonwebtoken.lang.Collections;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.server.validation.ValidationError;
import org.owasp.security.logging.SecurityMarkers;
import org.slf4j.Marker;

public abstract class AlpineResource {
    private static final ValidatorFactory VALIDATOR_FACTORY = Validation.buildDefaultValidatorFactory();
    protected static final String TOTAL_COUNT_HEADER = "X-Total-Count";
    @Context
    private ContainerRequestContext requestContext;
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;
    private AlpineRequest alpineRequest;

    protected ContainerRequestContext getRequestContext() {
        return this.requestContext;
    }

    protected UriInfo getUriInfo() {
        return this.uriInfo;
    }

    protected AlpineRequest getAlpineRequest() {
        return this.alpineRequest;
    }

    protected String getRemoteAddress() {
        return this.request.getRemoteAddr();
    }

    protected String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    protected String getUserAgent() {
        return this.requestContext.getHeaderString("User-Agent");
    }

    protected Validator getValidator() {
        return VALIDATOR_FACTORY.getValidator();
    }

    @SafeVarargs
    protected final List<ValidationError> contOnValidationError(Set<ConstraintViolation<Object>> ... violationsArray) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (Set<ConstraintViolation<Object>> violations : violationsArray) {
            for (ConstraintViolation<Object> violation : violations) {
                if (((Path.Node)violation.getPropertyPath().iterator().next()).getName() == null) continue;
                String path = violation.getPropertyPath() != null ? violation.getPropertyPath().toString() : null;
                String message = violation.getMessage() != null ? StringUtils.removeStart((String)violation.getMessage(), (String)(path + ".")) : null;
                String messageTemplate = violation.getMessageTemplate();
                String invalidValue = violation.getInvalidValue() != null ? violation.getInvalidValue().toString() : null;
                ValidationError error = new ValidationError(message, messageTemplate, path, invalidValue);
                errors.add(error);
            }
        }
        return errors;
    }

    @SafeVarargs
    protected final void failOnValidationError(Set<ConstraintViolation<Object>> ... violationsArray) {
        List<ValidationError> errors = this.contOnValidationError(violationsArray);
        if (!Collections.isEmpty(errors)) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(errors).build());
        }
    }

    protected final List<ValidationException> contOnValidationError(ValidationTask ... validationTasks) {
        ArrayList<ValidationException> errors = new ArrayList<ValidationException>();
        for (ValidationTask validationTask : validationTasks) {
            if (!validationTask.isRequired() && validationTask.getInput() == null || validationTask.getPattern().matcher(validationTask.getInput()).matches()) continue;
            errors.add(new ValidationException((Object)validationTask.getInput(), validationTask.getErrorMessage()));
        }
        return errors;
    }

    protected final void failOnValidationError(ValidationTask ... validationTasks) {
        List<ValidationException> errors = this.contOnValidationError(validationTasks);
        if (!Collections.isEmpty(errors)) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(errors).build());
        }
    }

    @PostConstruct
    private void initialize() {
        MultivaluedMap queryParams = this.uriInfo.getQueryParameters();
        String offset = this.multiParam((MultivaluedMap<String, String>)queryParams, "offset");
        String page = this.multiParam((MultivaluedMap<String, String>)queryParams, "page", "pageNumber");
        String size = this.multiParam((MultivaluedMap<String, String>)queryParams, "size", "pageSize", "limit");
        String filter = this.multiParam((MultivaluedMap<String, String>)queryParams, "filter", "searchText");
        String sort = this.multiParam((MultivaluedMap<String, String>)queryParams, "sort", "sortOrder");
        String orderBy = this.multiParam((MultivaluedMap<String, String>)queryParams, "orderBy", "sortName");
        if (StringUtils.isBlank((CharSequence)orderBy) || !RegexSequence.Pattern.STRING_IDENTIFIER.matcher(orderBy).matches()) {
            orderBy = null;
        }
        OrderDirection orderDirection = "asc".equalsIgnoreCase(sort) ? OrderDirection.ASCENDING : ("desc".equalsIgnoreCase(sort) ? OrderDirection.DESCENDING : OrderDirection.UNSPECIFIED);
        Pagination pagination = StringUtils.isNotBlank((CharSequence)offset) ? new Pagination(Pagination.Strategy.OFFSET, offset, size) : (StringUtils.isNotBlank((CharSequence)page) && StringUtils.isNotBlank((CharSequence)size) ? new Pagination(Pagination.Strategy.PAGES, page, size) : new Pagination(Pagination.Strategy.OFFSET, 0, 100));
        this.alpineRequest = new AlpineRequest(this.getPrincipal(), pagination, filter, orderBy, orderDirection);
    }

    private String multiParam(MultivaluedMap<String, String> queryParams, String ... params) {
        for (String param : params) {
            String value = (String)queryParams.getFirst((Object)param);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            return value;
        }
        return null;
    }

    protected Principal getPrincipal() {
        Object principal = this.requestContext.getProperty("Principal");
        if (principal != null) {
            return (Principal)principal;
        }
        return null;
    }

    protected boolean isOidcUser() {
        return this.getPrincipal() instanceof OidcUser;
    }

    protected boolean isLdapUser() {
        return this.getPrincipal() instanceof LdapUser;
    }

    protected boolean isManagedUser() {
        return this.getPrincipal() instanceof ManagedUser;
    }

    protected boolean isApiKey() {
        return this.getPrincipal() instanceof ApiKey;
    }

    protected boolean hasPermission(String permission) {
        if (this.getPrincipal() == null) {
            return false;
        }
        try (AlpineQueryManager qm = new AlpineQueryManager();){
            boolean hasPermission = false;
            if (this.getPrincipal() instanceof ApiKey) {
                hasPermission = qm.hasPermission((ApiKey)this.getPrincipal(), permission);
            } else if (this.getPrincipal() instanceof UserPrincipal) {
                hasPermission = qm.hasPermission((UserPrincipal)((Object)this.getPrincipal()), permission, true);
            }
            boolean bl = hasPermission;
            return bl;
        }
    }

    protected void logSecurityEvent(Logger logger, Marker marker, String message) {
        if (SecurityMarkers.SECURITY_AUDIT != marker && SecurityMarkers.SECURITY_SUCCESS != marker && SecurityMarkers.SECURITY_FAILURE != marker) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(message).append(" ");
        if (this.getPrincipal() != null) {
            sb.append("by: ").append(this.getPrincipal().getName()).append(" ");
        }
        sb.append("/ IP Address: ").append(this.getRemoteAddress()).append(" ");
        sb.append("/ User Agent: ").append(this.getUserAgent());
        logger.info(marker, sb.toString());
    }
}

