/*
 * Decompiled with CFR 0.152.
 */
package alpine.util;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class UuidUtil {
    private static final Pattern UUID_PATTERN = Pattern.compile("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$");

    private UuidUtil() {
    }

    public static String insertHyphens(String uuidWithoutHyphens) {
        return uuidWithoutHyphens.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5");
    }

    public static String stripHyphens(String uuid) {
        return uuid.replaceAll("-", "");
    }

    public static boolean isValidUUID(String uuid) {
        return !StringUtils.isEmpty((CharSequence)uuid) && UUID_PATTERN.matcher(uuid).matches();
    }
}

