/*
 * Decompiled with CFR 0.152.
 */
package us.springett.cvss;

import us.springett.cvss.Cvss;
import us.springett.cvss.Score;

public class CvssV2
implements Cvss {
    private static final double NO_VALUE = -1.0;
    private AttackVector av;
    private AttackComplexity ac;
    private Authentication au;
    private Exploitability e;
    private RemediationLevel rl;
    private ReportConfidence rc;
    private CIA c;
    private CIA i;
    private CIA a;

    public CvssV2 attackVector(AttackVector av) {
        this.av = av;
        return this;
    }

    public CvssV2 attackComplexity(AttackComplexity ac) {
        this.ac = ac;
        return this;
    }

    public CvssV2 authentication(Authentication au) {
        this.au = au;
        return this;
    }

    public CvssV2 confidentiality(CIA c) {
        this.c = c;
        return this;
    }

    public CvssV2 integrity(CIA i) {
        this.i = i;
        return this;
    }

    public CvssV2 availability(CIA a) {
        this.a = a;
        return this;
    }

    public CvssV2 exploitability(Exploitability e) {
        this.e = e;
        return this;
    }

    public CvssV2 remediationLevel(RemediationLevel rl) {
        this.rl = rl;
        return this;
    }

    public CvssV2 reportConfidence(ReportConfidence rc) {
        this.rc = rc;
        return this;
    }

    @Override
    public Score calculateScore() {
        double impactSubScore = 10.41 * (1.0 - (1.0 - this.c.weight) * (1.0 - this.i.weight) * (1.0 - this.a.weight));
        double exploitabalitySubScore = 20.0 * this.av.weight * this.ac.weight * this.au.weight;
        double baseScore = this.roundNearestTenth((0.6 * impactSubScore + 0.4 * exploitabalitySubScore - 1.5) * this.f(impactSubScore));
        double temporalScore = this.e != null && this.e.weight != -1.0 && this.rl != null && this.rl.weight != -1.0 && this.rc != null && this.rc.weight != -1.0 ? this.roundNearestTenth(baseScore * this.e.weight * this.rl.weight * this.rc.weight) : -1.0;
        return new Score(baseScore, this.roundNearestTenth(impactSubScore), this.roundNearestTenth(exploitabalitySubScore), temporalScore);
    }

    private double f(double impact) {
        return impact == 0.0 ? 0.0 : 1.176;
    }

    private double roundNearestTenth(double d) {
        return (double)Math.round(d * 10.0) / 10.0;
    }

    @Override
    public String getVector() {
        return "(AV:" + this.av.shorthand + "/AC:" + this.ac.shorthand + "/Au:" + this.au.shorthand + "/C:" + this.c.shorthand + "/I:" + this.i.shorthand + "/A:" + this.a.shorthand + (this.e != null && this.rl != null && this.rc != null ? "/E:" + this.e.shorthand + "/RL:" + this.rl.shorthand + "/RC:" + this.rc.shorthand + ")" : ")");
    }

    public AttackVector getAttackVector() {
        return this.av;
    }

    public AttackComplexity getAttackComplexity() {
        return this.ac;
    }

    public Authentication getAuthentication() {
        return this.au;
    }

    public Exploitability getExploitability() {
        return this.e;
    }

    public RemediationLevel getRemediationLevel() {
        return this.rl;
    }

    public ReportConfidence getReportConfidence() {
        return this.rc;
    }

    public CIA getConfidentiality() {
        return this.c;
    }

    public CIA getIntegrity() {
        return this.i;
    }

    public CIA getAvailability() {
        return this.a;
    }

    public String toString() {
        return this.getVector();
    }

    public static enum CIA {
        NONE(0.0, "N"),
        PARTIAL(0.275, "P"),
        COMPLETE(0.66, "C");

        private final double weight;
        private final String shorthand;

        private CIA(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static CIA fromString(String text) {
            for (CIA e : CIA.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum ReportConfidence {
        UNCONFIRMED(0.9, "UC"),
        UNCORROBORATED(0.95, "UR"),
        CONFIRMED(1.0, "C"),
        NOT_DEFINED(1.0, "ND");

        private final double weight;
        private final String shorthand;

        private ReportConfidence(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static ReportConfidence fromString(String text) {
            for (ReportConfidence e : ReportConfidence.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum RemediationLevel {
        UNAVAILABLE(1.0, "U"),
        WORKAROUND(0.95, "W"),
        TEMPORARY(0.9, "TF"),
        OFFICIAL(0.87, "OF"),
        NOT_DEFINED(1.0, "ND");

        private final double weight;
        private final String shorthand;

        private RemediationLevel(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static RemediationLevel fromString(String text) {
            for (RemediationLevel e : RemediationLevel.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum Exploitability {
        UNPROVEN(0.85, "U"),
        POC(0.9, "POC"),
        FUNCTIONAL(0.95, "F"),
        HIGH(1.0, "H"),
        NOT_DEFINED(1.0, "ND");

        private final double weight;
        private final String shorthand;

        private Exploitability(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static Exploitability fromString(String text) {
            for (Exploitability e : Exploitability.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum Authentication {
        NONE(0.704, "N"),
        SINGLE(0.56, "S"),
        MULTIPLE(0.45, "M");

        private final double weight;
        private final String shorthand;

        private Authentication(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static Authentication fromString(String text) {
            for (Authentication e : Authentication.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum AttackComplexity {
        LOW(0.71, "L"),
        MEDIUM(0.61, "M"),
        HIGH(0.35, "H");

        private final double weight;
        private final String shorthand;

        private AttackComplexity(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static AttackComplexity fromString(String text) {
            for (AttackComplexity e : AttackComplexity.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum AttackVector {
        NETWORK(1.0, "N"),
        ADJACENT(0.646, "A"),
        LOCAL(0.395, "L");

        private final double weight;
        private final String shorthand;

        private AttackVector(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static AttackVector fromString(String text) {
            for (AttackVector e : AttackVector.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }
}

