/*
 * Decompiled with CFR 0.152.
 */
package us.springett.cvss;

import us.springett.cvss.Cvss;
import us.springett.cvss.Score;

public class CvssV3
implements Cvss {
    protected static final double NO_VALUE = -1.0;
    protected static final double exploitabilityCoefficient = 8.22;
    protected static final double scopeCoefficient = 1.08;
    protected AttackVector av;
    protected AttackComplexity ac;
    protected PrivilegesRequired pr;
    protected UserInteraction ui;
    protected Scope s;
    protected Exploitability e;
    protected RemediationLevel rl;
    protected ReportConfidence rc;
    protected CIA c;
    protected CIA i;
    protected CIA a;

    public CvssV3 attackVector(AttackVector av) {
        this.av = av;
        return this;
    }

    public CvssV3 attackComplexity(AttackComplexity ac) {
        this.ac = ac;
        return this;
    }

    public CvssV3 privilegesRequired(PrivilegesRequired pr) {
        this.pr = pr;
        return this;
    }

    public CvssV3 userInteraction(UserInteraction ui) {
        this.ui = ui;
        return this;
    }

    public CvssV3 scope(Scope s) {
        this.s = s;
        return this;
    }

    public CvssV3 confidentiality(CIA c) {
        this.c = c;
        return this;
    }

    public CvssV3 integrity(CIA i) {
        this.i = i;
        return this;
    }

    public CvssV3 availability(CIA a) {
        this.a = a;
        return this;
    }

    public CvssV3 exploitability(Exploitability e) {
        this.e = e;
        return this;
    }

    public CvssV3 remediationLevel(RemediationLevel rl) {
        this.rl = rl;
        return this;
    }

    public CvssV3 reportConfidence(ReportConfidence rc) {
        this.rc = rc;
        return this;
    }

    @Override
    public Score calculateScore() {
        double prWeight = Scope.UNCHANGED == this.s ? this.pr.weight : this.pr.scopeChangedWeight;
        double exploitabalitySubScore = 8.22 * this.av.weight * this.ac.weight * prWeight * this.ui.weight;
        double impactSubScoreMultiplier = 1.0 - (1.0 - this.c.weight) * (1.0 - this.i.weight) * (1.0 - this.a.weight);
        double impactSubScore = Scope.UNCHANGED == this.s ? this.s.weight * impactSubScoreMultiplier : this.s.weight * (impactSubScoreMultiplier - 0.029) - 3.25 * Math.pow(impactSubScoreMultiplier - 0.02, 15.0);
        double baseScore = impactSubScore <= 0.0 ? 0.0 : (Scope.UNCHANGED == this.s ? this.roundUp1(Math.min(exploitabalitySubScore + impactSubScore, 10.0)) : this.roundUp1(Math.min((exploitabalitySubScore + impactSubScore) * 1.08, 10.0)));
        double temporalScore = this.e != null && this.e.weight != -1.0 && this.rl != null && this.rl.weight != -1.0 && this.rc != null && this.rc.weight != -1.0 ? this.roundUp1(baseScore * this.e.weight * this.rl.weight * this.rc.weight) : -1.0;
        return new Score(baseScore, this.roundNearestTenth(impactSubScore), this.roundNearestTenth(exploitabalitySubScore), temporalScore);
    }

    private double roundUp1(double d) {
        return Math.ceil(d * 10.0) / 10.0;
    }

    protected double roundNearestTenth(double d) {
        return (double)Math.round(d * 10.0) / 10.0;
    }

    @Override
    public String getVector() {
        return "CVSS:3.0/AV:" + this.av.shorthand + "/AC:" + this.ac.shorthand + "/PR:" + this.pr.shorthand + "/UI:" + this.ui.shorthand + "/S:" + this.s.shorthand + "/C:" + this.c.shorthand + "/I:" + this.i.shorthand + "/A:" + this.a.shorthand + (this.e != null && this.rl != null && this.rc != null ? "/E:" + this.e.shorthand + "/RL:" + this.rl.shorthand + "/RC:" + this.rc.shorthand : "");
    }

    public AttackVector getAttackVector() {
        return this.av;
    }

    public AttackComplexity getAttackComplexity() {
        return this.ac;
    }

    public PrivilegesRequired getPrivilegesRequired() {
        return this.pr;
    }

    public UserInteraction getUserInteraction() {
        return this.ui;
    }

    public Scope getScope() {
        return this.s;
    }

    public Exploitability getExploitability() {
        return this.e;
    }

    public RemediationLevel getRemediationLevel() {
        return this.rl;
    }

    public ReportConfidence getReportConfidence() {
        return this.rc;
    }

    public CIA getConfidentiality() {
        return this.c;
    }

    public CIA getIntegrity() {
        return this.i;
    }

    public CIA getAvailability() {
        return this.a;
    }

    public String toString() {
        return this.getVector();
    }

    public static enum CIA {
        NONE(0.0, "N"),
        LOW(0.22, "L"),
        HIGH(0.56, "H");

        protected final double weight;
        protected final String shorthand;

        private CIA(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static CIA fromString(String text) {
            for (CIA e : CIA.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum ReportConfidence {
        UNKNOWN(0.92, "U"),
        REASONABLE(0.96, "R"),
        CONFIRMED(1.0, "C"),
        NOT_DEFINED(1.0, "X");

        protected final double weight;
        protected final String shorthand;

        private ReportConfidence(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static ReportConfidence fromString(String text) {
            for (ReportConfidence e : ReportConfidence.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum RemediationLevel {
        UNAVAILABLE(1.0, "U"),
        WORKAROUND(0.97, "W"),
        TEMPORARY(0.96, "T"),
        OFFICIAL(0.95, "O"),
        NOT_DEFINED(1.0, "X");

        protected final double weight;
        protected final String shorthand;

        private RemediationLevel(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static RemediationLevel fromString(String text) {
            for (RemediationLevel e : RemediationLevel.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum Exploitability {
        UNPROVEN(0.91, "U"),
        POC(0.94, "P"),
        FUNCTIONAL(0.97, "F"),
        HIGH(1.0, "H"),
        NOT_DEFINED(1.0, "X");

        protected final double weight;
        protected final String shorthand;

        private Exploitability(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static Exploitability fromString(String text) {
            for (Exploitability e : Exploitability.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum Scope {
        UNCHANGED(6.42, "U"),
        CHANGED(7.52, "C");

        protected final double weight;
        protected final String shorthand;

        private Scope(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static Scope fromString(String text) {
            for (Scope e : Scope.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum UserInteraction {
        NONE(0.85, "N"),
        REQUIRED(0.62, "R");

        protected final double weight;
        protected final String shorthand;

        private UserInteraction(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static UserInteraction fromString(String text) {
            for (UserInteraction e : UserInteraction.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum PrivilegesRequired {
        NONE(0.85, 0.85, "N"),
        LOW(0.62, 0.68, "L"),
        HIGH(0.27, 0.5, "H");

        protected final double weight;
        protected final double scopeChangedWeight;
        protected final String shorthand;

        private PrivilegesRequired(double weight, double scopeChangedWeight, String shorthand) {
            this.weight = weight;
            this.scopeChangedWeight = scopeChangedWeight;
            this.shorthand = shorthand;
        }

        public static PrivilegesRequired fromString(String text) {
            for (PrivilegesRequired e : PrivilegesRequired.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum AttackComplexity {
        LOW(0.77, "L"),
        HIGH(0.44, "H");

        protected final double weight;
        protected final String shorthand;

        private AttackComplexity(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static AttackComplexity fromString(String text) {
            for (AttackComplexity e : AttackComplexity.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum AttackVector {
        NETWORK(0.85, "N"),
        ADJACENT(0.62, "A"),
        LOCAL(0.55, "L"),
        PHYSICAL(0.2, "P");

        protected final double weight;
        protected final String shorthand;

        private AttackVector(double weight, String shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static AttackVector fromString(String text) {
            for (AttackVector e : AttackVector.values()) {
                if (!e.shorthand.equalsIgnoreCase(text)) continue;
                return e;
            }
            return null;
        }
    }
}

