/*
 * Decompiled with CFR 0.152.
 */
package us.springett.cvss;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.springett.cvss.CvssV2;
import us.springett.cvss.CvssV3;
import us.springett.cvss.CvssV3_1;
import us.springett.cvss.Score;

public interface Cvss {
    public static final String V2_PATTERN = "AV:[NAL]\\/AC:[LMH]\\/A[Uu]:[NSM]\\/C:[NPC]\\/I:[NPC]\\/A:[NPC]";
    public static final String V2_TEMPORAL = "\\/E:\\b(F|H|U|POC|ND)\\b\\/RL:\\b(W|U|TF|OF|ND)\\b\\/RC:\\b(C|UR|UC|ND)\\b";
    public static final String V3_PATTERN = "AV:[NALP]\\/AC:[LH]\\/PR:[NLH]\\/UI:[NR]\\/S:[UC]\\/C:[NLH]\\/I:[NLH]\\/A:[NLH]";
    public static final String V3_TEMPORAL = "\\/E:[F|H|U|P|X]\\/RL:[W|U|T|O|X]\\/RC:[C|R|U|X]";
    public static final String V3_1_ENVIRONMENTAL = "\\/CR:[X|L|M|H]\\/IR:[X|L|M|H]\\/AR:[X|L|M|H]\\/MAV:[X|N|A|L|P]\\/MAC:[X|L|H]\\/MPR:[X|N|L|H]\\/MUI:[X|N|R]\\/MS:[X|U|C]\\/MC:[X|N|L|H]\\/MI:[X|N|L|H]\\/MA:[X|N|L|H]";
    public static final Pattern CVSSv2_PATTERN = Pattern.compile("AV:[NAL]\\/AC:[LMH]\\/A[Uu]:[NSM]\\/C:[NPC]\\/I:[NPC]\\/A:[NPC]");
    public static final Pattern CVSSv2_PATTERN_TEMPORAL = Pattern.compile("AV:[NAL]\\/AC:[LMH]\\/A[Uu]:[NSM]\\/C:[NPC]\\/I:[NPC]\\/A:[NPC]\\/E:\\b(F|H|U|POC|ND)\\b\\/RL:\\b(W|U|TF|OF|ND)\\b\\/RC:\\b(C|UR|UC|ND)\\b");
    public static final Pattern CVSSv3_PATTERN = Pattern.compile("AV:[NALP]\\/AC:[LH]\\/PR:[NLH]\\/UI:[NR]\\/S:[UC]\\/C:[NLH]\\/I:[NLH]\\/A:[NLH]");
    public static final Pattern CVSSv3_PATTERN_TEMPORAL = Pattern.compile("AV:[NALP]\\/AC:[LH]\\/PR:[NLH]\\/UI:[NR]\\/S:[UC]\\/C:[NLH]\\/I:[NLH]\\/A:[NLH]\\/E:[F|H|U|P|X]\\/RL:[W|U|T|O|X]\\/RC:[C|R|U|X]");
    public static final Pattern CVSSv3_1_PATTERN = Pattern.compile("AV:[NALP]\\/AC:[LH]\\/PR:[NLH]\\/UI:[NR]\\/S:[UC]\\/C:[NLH]\\/I:[NLH]\\/A:[NLH]\\/E:[F|H|U|P|X]\\/RL:[W|U|T|O|X]\\/RC:[C|R|U|X]\\/CR:[X|L|M|H]\\/IR:[X|L|M|H]\\/AR:[X|L|M|H]\\/MAV:[X|N|A|L|P]\\/MAC:[X|L|H]\\/MPR:[X|N|L|H]\\/MUI:[X|N|R]\\/MS:[X|U|C]\\/MC:[X|N|L|H]\\/MI:[X|N|L|H]\\/MA:[X|N|L|H]");

    public static Cvss fromVector(String vector) {
        if (vector == null) {
            return null;
        }
        Matcher v2Matcher = CVSSv2_PATTERN.matcher(vector);
        Matcher v2TemporalMatcher = CVSSv2_PATTERN_TEMPORAL.matcher(vector);
        Matcher v3Matcher = CVSSv3_PATTERN.matcher(vector);
        Matcher v3TemporalMatcher = CVSSv3_PATTERN_TEMPORAL.matcher(vector);
        Matcher v3_1Matcher = CVSSv3_1_PATTERN.matcher(vector);
        if (v2TemporalMatcher.find()) {
            String matchedVector = v2TemporalMatcher.group(0);
            StringTokenizer st = new StringTokenizer(matchedVector, "/");
            CvssV2 cvssV2 = Cvss.getCvssV2BaseVector(st);
            cvssV2.exploitability(CvssV2.Exploitability.fromString(st.nextElement().toString().split(":")[1]));
            cvssV2.remediationLevel(CvssV2.RemediationLevel.fromString(st.nextElement().toString().split(":")[1]));
            cvssV2.reportConfidence(CvssV2.ReportConfidence.fromString(st.nextElement().toString().split(":")[1]));
            return cvssV2;
        }
        if (v2Matcher.find()) {
            String matchedVector = v2Matcher.group(0);
            StringTokenizer st = new StringTokenizer(matchedVector, "/");
            return Cvss.getCvssV2BaseVector(st);
        }
        if (v3_1Matcher.find()) {
            String matchedVector = v3_1Matcher.group(0);
            StringTokenizer st = new StringTokenizer(matchedVector, "/");
            CvssV3_1 cvssV3_1 = Cvss.getCvssV3_1BaseVector(st);
            cvssV3_1.exploitability(CvssV3.Exploitability.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3_1.remediationLevel(CvssV3.RemediationLevel.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3_1.reportConfidence(CvssV3.ReportConfidence.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3_1.confidentialityRequirement(CvssV3_1.ConfidentialityRequirement.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3_1.integrityRequirement(CvssV3_1.IntegrityRequirement.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3_1.availabilityRequirement(CvssV3_1.AvailabilityRequirement.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3_1.modifiedAttackVector(CvssV3_1.ModifiedAttackVector.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3_1.modifiedAttackComplexity(CvssV3_1.ModifiedAttackComplexity.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3_1.modifiedPrivilegesRequired(CvssV3_1.ModifiedPrivilegesRequired.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3_1.modifiedUserInteraction(CvssV3_1.ModifiedUserInteraction.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3_1.modifiedScope(CvssV3_1.ModifiedScope.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3_1.modifiedConfidentialityImpact(CvssV3_1.ModifiedCIA.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3_1.modifiedIntegrityImpact(CvssV3_1.ModifiedCIA.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3_1.modifiedAvailabilityImpact(CvssV3_1.ModifiedCIA.fromString(st.nextElement().toString().split(":")[1]));
            return cvssV3_1;
        }
        if (v3TemporalMatcher.find()) {
            String matchedVector = v3TemporalMatcher.group(0);
            StringTokenizer st = new StringTokenizer(matchedVector, "/");
            CvssV3 cvssV3 = Cvss.getCvssV3BaseVector(st);
            cvssV3.exploitability(CvssV3.Exploitability.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3.remediationLevel(CvssV3.RemediationLevel.fromString(st.nextElement().toString().split(":")[1]));
            cvssV3.reportConfidence(CvssV3.ReportConfidence.fromString(st.nextElement().toString().split(":")[1]));
            return cvssV3;
        }
        if (v3Matcher.find()) {
            String matchedVector = v3Matcher.group(0);
            StringTokenizer st = new StringTokenizer(matchedVector, "/");
            return Cvss.getCvssV3BaseVector(st);
        }
        return null;
    }

    public static CvssV2 getCvssV2BaseVector(StringTokenizer st) {
        CvssV2 cvssV2 = new CvssV2();
        cvssV2.attackVector(CvssV2.AttackVector.fromString(st.nextElement().toString().split(":")[1]));
        cvssV2.attackComplexity(CvssV2.AttackComplexity.fromString(st.nextElement().toString().split(":")[1]));
        cvssV2.authentication(CvssV2.Authentication.fromString(st.nextElement().toString().split(":")[1]));
        cvssV2.confidentiality(CvssV2.CIA.fromString(st.nextElement().toString().split(":")[1]));
        cvssV2.integrity(CvssV2.CIA.fromString(st.nextElement().toString().split(":")[1]));
        cvssV2.availability(CvssV2.CIA.fromString(st.nextElement().toString().split(":")[1]));
        return cvssV2;
    }

    public static CvssV3 getCvssV3BaseVector(StringTokenizer st) {
        CvssV3 cvssV3 = new CvssV3();
        cvssV3.attackVector(CvssV3.AttackVector.fromString(st.nextElement().toString().split(":")[1]));
        cvssV3.attackComplexity(CvssV3.AttackComplexity.fromString(st.nextElement().toString().split(":")[1]));
        cvssV3.privilegesRequired(CvssV3.PrivilegesRequired.fromString(st.nextElement().toString().split(":")[1]));
        cvssV3.userInteraction(CvssV3.UserInteraction.fromString(st.nextElement().toString().split(":")[1]));
        cvssV3.scope(CvssV3.Scope.fromString(st.nextElement().toString().split(":")[1]));
        cvssV3.confidentiality(CvssV3.CIA.fromString(st.nextElement().toString().split(":")[1]));
        cvssV3.integrity(CvssV3.CIA.fromString(st.nextElement().toString().split(":")[1]));
        cvssV3.availability(CvssV3.CIA.fromString(st.nextElement().toString().split(":")[1]));
        return cvssV3;
    }

    public static CvssV3_1 getCvssV3_1BaseVector(StringTokenizer st) {
        CvssV3_1 cvssV3_1 = new CvssV3_1();
        cvssV3_1.attackVector(CvssV3.AttackVector.fromString(st.nextElement().toString().split(":")[1]));
        cvssV3_1.attackComplexity(CvssV3.AttackComplexity.fromString(st.nextElement().toString().split(":")[1]));
        cvssV3_1.privilegesRequired(CvssV3.PrivilegesRequired.fromString(st.nextElement().toString().split(":")[1]));
        cvssV3_1.userInteraction(CvssV3.UserInteraction.fromString(st.nextElement().toString().split(":")[1]));
        cvssV3_1.scope(CvssV3.Scope.fromString(st.nextElement().toString().split(":")[1]));
        cvssV3_1.confidentiality(CvssV3.CIA.fromString(st.nextElement().toString().split(":")[1]));
        cvssV3_1.integrity(CvssV3.CIA.fromString(st.nextElement().toString().split(":")[1]));
        cvssV3_1.availability(CvssV3.CIA.fromString(st.nextElement().toString().split(":")[1]));
        return cvssV3_1;
    }

    public Score calculateScore();

    public String getVector();
}

