/*
 * Decompiled with CFR 0.152.
 */
package us.springett.cvss;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.springett.cvss.CvssV2;
import us.springett.cvss.CvssV3;
import us.springett.cvss.CvssV3_1;
import us.springett.cvss.Score;

public interface Cvss {
    public static final String V2_PATTERN = "AV:(N|A|L)\\/AC:(L|M|H)\\/A[Uu]:(N|S|M)\\/C:(N|P|C)\\/I:(N|P|C)\\/A:(N|P|C)";
    public static final String V2_TEMPORAL = "\\/E:\\b(F|H|U|POC|ND)\\b\\/RL:\\b(W|U|TF|OF|ND)\\b\\/RC:\\b(C|UR|UC|ND)\\b";
    public static final String V3_PATTERN = "AV:(N|A|L|P)\\/AC:(L|H)\\/PR:(N|L|H)\\/UI:(N|R)\\/S:(U|C)\\/C:(N|L|H)\\/I:(N|L|H)\\/A:(N|L|H)";
    public static final String V3_TEMPORAL = "\\/E:(F|H|U|P|X)\\/RL:(W|U|T|O|X)\\/RC:(C|R|U|X)";
    public static final String V3_1_ENVIRONMENTAL = "\\/CR:(X|L|M|H)\\/IR:(X|L|M|H)\\/AR:(X|L|M|H)\\/MAV:(X|N|A|L|P)\\/MAC:(X|L|H)\\/MPR:(X|N|L|H)\\/MUI:(X|N|R)\\/MS:(X|U|C)\\/MC:(X|N|L|H)\\/MI:(X|N|L|H)\\/MA:(X|N|L|H)";
    public static final Pattern CVSSv2_PATTERN = Pattern.compile("AV:(N|A|L)\\/AC:(L|M|H)\\/A[Uu]:(N|S|M)\\/C:(N|P|C)\\/I:(N|P|C)\\/A:(N|P|C)");
    public static final Pattern CVSSv2_PATTERN_TEMPORAL = Pattern.compile("AV:(N|A|L)\\/AC:(L|M|H)\\/A[Uu]:(N|S|M)\\/C:(N|P|C)\\/I:(N|P|C)\\/A:(N|P|C)\\/E:\\b(F|H|U|POC|ND)\\b\\/RL:\\b(W|U|TF|OF|ND)\\b\\/RC:\\b(C|UR|UC|ND)\\b");
    public static final Pattern CVSSv3_PATTERN = Pattern.compile("AV:(N|A|L|P)\\/AC:(L|H)\\/PR:(N|L|H)\\/UI:(N|R)\\/S:(U|C)\\/C:(N|L|H)\\/I:(N|L|H)\\/A:(N|L|H)");
    public static final Pattern CVSSv3_PATTERN_TEMPORAL = Pattern.compile("AV:(N|A|L|P)\\/AC:(L|H)\\/PR:(N|L|H)\\/UI:(N|R)\\/S:(U|C)\\/C:(N|L|H)\\/I:(N|L|H)\\/A:(N|L|H)\\/E:(F|H|U|P|X)\\/RL:(W|U|T|O|X)\\/RC:(C|R|U|X)");
    public static final Pattern CVSSv3_1_PATTERN = Pattern.compile("AV:(N|A|L|P)\\/AC:(L|H)\\/PR:(N|L|H)\\/UI:(N|R)\\/S:(U|C)\\/C:(N|L|H)\\/I:(N|L|H)\\/A:(N|L|H)\\/E:(F|H|U|P|X)\\/RL:(W|U|T|O|X)\\/RC:(C|R|U|X)\\/CR:(X|L|M|H)\\/IR:(X|L|M|H)\\/AR:(X|L|M|H)\\/MAV:(X|N|A|L|P)\\/MAC:(X|L|H)\\/MPR:(X|N|L|H)\\/MUI:(X|N|R)\\/MS:(X|U|C)\\/MC:(X|N|L|H)\\/MI:(X|N|L|H)\\/MA:(X|N|L|H)");

    public static Cvss fromVector(String vector) {
        if (vector == null) {
            return null;
        }
        Matcher v3_1Matcher = CVSSv3_1_PATTERN.matcher(vector);
        if (v3_1Matcher.find()) {
            char[] vectorChars = vector.toCharArray();
            CvssV3_1 cvssV3_1 = Cvss.getCvssV3_1BaseVector(v3_1Matcher, vectorChars);
            Cvss.fillV3TemporalValues(v3_1Matcher, vectorChars, cvssV3_1);
            cvssV3_1.confidentialityRequirement(CvssV3_1.ConfidentialityRequirement.fromChar(vectorChars[v3_1Matcher.start(12)]));
            cvssV3_1.integrityRequirement(CvssV3_1.IntegrityRequirement.fromChar(vectorChars[v3_1Matcher.start(13)]));
            cvssV3_1.availabilityRequirement(CvssV3_1.AvailabilityRequirement.fromChar(vectorChars[v3_1Matcher.start(14)]));
            cvssV3_1.modifiedAttackVector(CvssV3_1.ModifiedAttackVector.fromChar(vectorChars[v3_1Matcher.start(15)]));
            cvssV3_1.modifiedAttackComplexity(CvssV3_1.ModifiedAttackComplexity.fromChar(vectorChars[v3_1Matcher.start(16)]));
            cvssV3_1.modifiedPrivilegesRequired(CvssV3_1.ModifiedPrivilegesRequired.fromChar(vectorChars[v3_1Matcher.start(17)]));
            cvssV3_1.modifiedUserInteraction(CvssV3_1.ModifiedUserInteraction.fromChar(vectorChars[v3_1Matcher.start(18)]));
            cvssV3_1.modifiedScope(CvssV3_1.ModifiedScope.fromChar(vectorChars[v3_1Matcher.start(19)]));
            cvssV3_1.modifiedConfidentialityImpact(CvssV3_1.ModifiedCIA.fromChar(vectorChars[v3_1Matcher.start(20)]));
            cvssV3_1.modifiedIntegrityImpact(CvssV3_1.ModifiedCIA.fromChar(vectorChars[v3_1Matcher.start(21)]));
            cvssV3_1.modifiedAvailabilityImpact(CvssV3_1.ModifiedCIA.fromChar(vectorChars[v3_1Matcher.start(22)]));
            return cvssV3_1;
        }
        Matcher v3TemporalMatcher = CVSSv3_PATTERN_TEMPORAL.matcher(vector);
        if (v3TemporalMatcher.find()) {
            char[] vectorChars = vector.toCharArray();
            CvssV3 cvssV3 = Cvss.getCvssV3BaseVector(v3TemporalMatcher, vectorChars);
            Cvss.fillV3TemporalValues(v3TemporalMatcher, vectorChars, cvssV3);
            return cvssV3;
        }
        Matcher v3Matcher = CVSSv3_PATTERN.matcher(vector);
        if (v3Matcher.find()) {
            char[] vectorChars = vector.toCharArray();
            return Cvss.getCvssV3BaseVector(v3Matcher, vectorChars);
        }
        Matcher v2TemporalMatcher = CVSSv2_PATTERN_TEMPORAL.matcher(vector);
        if (v2TemporalMatcher.find()) {
            CvssV2 cvssV2 = Cvss.getCvssV2BaseVector(v2TemporalMatcher, vector.toCharArray());
            cvssV2.exploitability(CvssV2.Exploitability.fromString(v2TemporalMatcher.group(7)));
            cvssV2.remediationLevel(CvssV2.RemediationLevel.fromString(v2TemporalMatcher.group(8)));
            cvssV2.reportConfidence(CvssV2.ReportConfidence.fromString(v2TemporalMatcher.group(9)));
            return cvssV2;
        }
        Matcher v2Matcher = CVSSv2_PATTERN.matcher(vector);
        if (v2Matcher.find()) {
            return Cvss.getCvssV2BaseVector(v2Matcher, vector.toCharArray());
        }
        return null;
    }

    public static void fillV3TemporalValues(Matcher v3TemporalMatcher, char[] vectorChars, CvssV3 cvssV3) {
        cvssV3.exploitability(CvssV3.Exploitability.fromChar(vectorChars[v3TemporalMatcher.start(9)]));
        cvssV3.remediationLevel(CvssV3.RemediationLevel.fromChar(vectorChars[v3TemporalMatcher.start(10)]));
        cvssV3.reportConfidence(CvssV3.ReportConfidence.fromChar(vectorChars[v3TemporalMatcher.start(11)]));
    }

    public static CvssV2 getCvssV2BaseVector(Matcher st, char[] array) {
        CvssV2 cvssV2 = new CvssV2();
        cvssV2.attackVector(CvssV2.AttackVector.fromChar(array[st.start(1)]));
        cvssV2.attackComplexity(CvssV2.AttackComplexity.fromChar(array[st.start(2)]));
        cvssV2.authentication(CvssV2.Authentication.fromChar(array[st.start(3)]));
        cvssV2.confidentiality(CvssV2.CIA.fromChar(array[st.start(4)]));
        cvssV2.integrity(CvssV2.CIA.fromChar(array[st.start(5)]));
        cvssV2.availability(CvssV2.CIA.fromChar(array[st.start(6)]));
        return cvssV2;
    }

    public static CvssV3 getCvssV3BaseVector(Matcher st, char[] array) {
        CvssV3 cvssV3 = new CvssV3();
        cvssV3.attackVector(CvssV3.AttackVector.fromChar(array[st.start(1)]));
        cvssV3.attackComplexity(CvssV3.AttackComplexity.fromChar(array[st.start(2)]));
        cvssV3.privilegesRequired(CvssV3.PrivilegesRequired.fromChar(array[st.start(3)]));
        cvssV3.userInteraction(CvssV3.UserInteraction.fromChar(array[st.start(4)]));
        cvssV3.scope(CvssV3.Scope.fromChar(array[st.start(5)]));
        cvssV3.confidentiality(CvssV3.CIA.fromString(array[st.start(6)]));
        cvssV3.integrity(CvssV3.CIA.fromString(array[st.start(7)]));
        cvssV3.availability(CvssV3.CIA.fromString(array[st.start(8)]));
        return cvssV3;
    }

    public static CvssV3_1 getCvssV3_1BaseVector(Matcher st, char[] array) {
        CvssV3_1 cvssV3_1 = new CvssV3_1();
        cvssV3_1.attackVector(CvssV3.AttackVector.fromChar(array[st.start(1)]));
        cvssV3_1.attackComplexity(CvssV3.AttackComplexity.fromChar(array[st.start(2)]));
        cvssV3_1.privilegesRequired(CvssV3.PrivilegesRequired.fromChar(array[st.start(3)]));
        cvssV3_1.userInteraction(CvssV3.UserInteraction.fromChar(array[st.start(4)]));
        cvssV3_1.scope(CvssV3.Scope.fromChar(array[st.start(5)]));
        cvssV3_1.confidentiality(CvssV3.CIA.fromString(array[st.start(6)]));
        cvssV3_1.integrity(CvssV3.CIA.fromString(array[st.start(7)]));
        cvssV3_1.availability(CvssV3.CIA.fromString(array[st.start(8)]));
        return cvssV3_1;
    }

    public Score calculateScore();

    public String getVector();
}

