/*
 * Decompiled with CFR 0.152.
 */
package us.springett.cvss;

import us.springett.cvss.CvssV3;
import us.springett.cvss.Score;

public class CvssV3_1
extends CvssV3 {
    protected ModifiedAttackVector mav;
    protected ModifiedAttackComplexity mac;
    protected ModifiedPrivilegesRequired mpr;
    protected ModifiedUserInteraction mui;
    protected ModifiedScope ms;
    protected ModifiedCIA mc;
    protected ModifiedCIA mi;
    protected ModifiedCIA ma;
    protected ConfidentialityRequirement cr;
    protected IntegrityRequirement ir;
    protected AvailabilityRequirement ar;

    @Override
    public CvssV3_1 attackVector(CvssV3.AttackVector av) {
        this.av = av;
        return this;
    }

    @Override
    public CvssV3_1 attackComplexity(CvssV3.AttackComplexity ac) {
        this.ac = ac;
        return this;
    }

    @Override
    public CvssV3_1 privilegesRequired(CvssV3.PrivilegesRequired pr) {
        this.pr = pr;
        return this;
    }

    @Override
    public CvssV3_1 userInteraction(CvssV3.UserInteraction ui) {
        this.ui = ui;
        return this;
    }

    @Override
    public CvssV3_1 scope(CvssV3.Scope s) {
        this.s = s;
        return this;
    }

    @Override
    public CvssV3_1 confidentiality(CvssV3.CIA c) {
        this.c = c;
        return this;
    }

    @Override
    public CvssV3_1 integrity(CvssV3.CIA i) {
        this.i = i;
        return this;
    }

    @Override
    public CvssV3_1 availability(CvssV3.CIA a) {
        this.a = a;
        return this;
    }

    @Override
    public CvssV3_1 exploitability(CvssV3.Exploitability e) {
        this.e = e;
        return this;
    }

    @Override
    public CvssV3_1 remediationLevel(CvssV3.RemediationLevel rl) {
        this.rl = rl;
        return this;
    }

    @Override
    public CvssV3_1 reportConfidence(CvssV3.ReportConfidence rc) {
        this.rc = rc;
        return this;
    }

    public CvssV3_1 confidentialityRequirement(ConfidentialityRequirement cr) {
        this.cr = cr;
        return this;
    }

    public CvssV3_1 integrityRequirement(IntegrityRequirement ir) {
        this.ir = ir;
        return this;
    }

    public CvssV3_1 availabilityRequirement(AvailabilityRequirement ar) {
        this.ar = ar;
        return this;
    }

    public CvssV3_1 modifiedAttackVector(ModifiedAttackVector mav) {
        this.mav = mav;
        return this;
    }

    public CvssV3_1 modifiedAttackComplexity(ModifiedAttackComplexity mac) {
        this.mac = mac;
        return this;
    }

    public CvssV3_1 modifiedPrivilegesRequired(ModifiedPrivilegesRequired mpr) {
        this.mpr = mpr;
        return this;
    }

    public CvssV3_1 modifiedUserInteraction(ModifiedUserInteraction mui) {
        this.mui = mui;
        return this;
    }

    public CvssV3_1 modifiedScope(ModifiedScope ms) {
        this.ms = ms;
        return this;
    }

    public CvssV3_1 modifiedConfidentialityImpact(ModifiedCIA mc) {
        this.mc = mc;
        return this;
    }

    public CvssV3_1 modifiedIntegrityImpact(ModifiedCIA mi) {
        this.mi = mi;
        return this;
    }

    public CvssV3_1 modifiedAvailabilityImpact(ModifiedCIA ma) {
        this.ma = ma;
        return this;
    }

    @Override
    public Score calculateScore() {
        double environmentalScore;
        double modifiedImpactSubScore;
        double mprWeight;
        boolean mprNotDefined;
        double baseScore;
        double prWeight = CvssV3.Scope.UNCHANGED == this.s ? this.pr.weight : this.pr.scopeChangedWeight;
        double exploitabilitySubScore = 8.22 * this.av.weight * this.ac.weight * prWeight * this.ui.weight;
        double impactSubScoreMultiplier = 1.0 - (1.0 - this.c.weight) * (1.0 - this.i.weight) * (1.0 - this.a.weight);
        double modifiedImpactSubScoreMultiplier = Math.min(1.0 - (1.0 - this.cr.weight * this.mc.weight) * (1.0 - this.ir.weight * this.mi.weight) * (1.0 - this.ar.weight * this.ma.weight), 0.915);
        double impactSubScore = CvssV3.Scope.UNCHANGED == this.s ? this.s.weight * impactSubScoreMultiplier : this.s.weight * (impactSubScoreMultiplier - 0.029) - 3.25 * Math.pow(impactSubScoreMultiplier - 0.02, 15.0);
        if (impactSubScore <= 0.0) {
            baseScore = 0.0;
            impactSubScore = 0.0;
        } else {
            baseScore = CvssV3.Scope.UNCHANGED == this.s ? this.roundUp1(Math.min(impactSubScore + exploitabilitySubScore, 10.0)) : this.roundUp1(Math.min((impactSubScore + exploitabilitySubScore) * 1.08, 10.0));
        }
        double temporalScore = this.roundUp1(baseScore * this.e.weight * this.rl.weight * this.rc.weight);
        boolean bl = mprNotDefined = this.mpr == ModifiedPrivilegesRequired.NOT_DEFINED;
        if (ModifiedScope.UNCHANGED == this.ms) {
            mprWeight = mprNotDefined ? this.pr.weight : this.mpr.weight;
            modifiedImpactSubScore = this.ms.weight * modifiedImpactSubScoreMultiplier;
        } else if (ModifiedScope.CHANGED == this.ms) {
            mprWeight = mprNotDefined ? this.pr.scopeChangedWeight : this.mpr.scopeChangedWeight;
            modifiedImpactSubScore = this.ms.weight * (modifiedImpactSubScoreMultiplier - 0.029) - 3.25 * Math.pow(modifiedImpactSubScoreMultiplier * 0.9731 - 0.02, 13.0);
        } else if (CvssV3.Scope.UNCHANGED == this.s) {
            mprWeight = mprNotDefined ? this.pr.weight : this.mpr.weight;
            modifiedImpactSubScore = this.s.weight * modifiedImpactSubScoreMultiplier;
        } else {
            mprWeight = mprNotDefined ? this.pr.scopeChangedWeight : this.mpr.scopeChangedWeight;
            modifiedImpactSubScore = this.s.weight * (modifiedImpactSubScoreMultiplier - 0.029) - 3.25 * Math.pow(modifiedImpactSubScoreMultiplier * 0.9731 - 0.02, 13.0);
        }
        double mavWeight = this.mav == ModifiedAttackVector.NOT_DEFINED ? this.av.weight : this.mav.weight;
        double macWeight = this.mac == ModifiedAttackComplexity.NOT_DEFINED ? this.ac.weight : this.mac.weight;
        double muiWeight = this.mui == ModifiedUserInteraction.NOT_DEFINED ? this.ui.weight : this.mui.weight;
        double modifiedExploitabilitySubScore = 8.22 * mavWeight * macWeight * mprWeight * muiWeight;
        if (modifiedImpactSubScore <= 0.0) {
            environmentalScore = 0.0;
            modifiedImpactSubScore = 0.0;
        } else {
            environmentalScore = ModifiedScope.UNCHANGED == this.ms || ModifiedScope.NOT_DEFINED == this.ms && CvssV3.Scope.UNCHANGED == this.s ? this.roundUp1(this.roundUp1(Math.min(modifiedImpactSubScore + modifiedExploitabilitySubScore, 10.0)) * this.e.weight * this.rl.weight * this.rc.weight) : (ModifiedScope.CHANGED == this.ms || ModifiedScope.NOT_DEFINED == this.ms && CvssV3.Scope.CHANGED == this.s ? this.roundUp1(this.roundUp1(Math.min(1.08 * (modifiedImpactSubScore + modifiedExploitabilitySubScore), 10.0)) * this.e.weight * this.rl.weight * this.rc.weight) : 0.0);
        }
        return new Score(baseScore, this.roundNearestTenth(impactSubScore), this.roundNearestTenth(exploitabilitySubScore), temporalScore, environmentalScore, this.roundNearestTenth(modifiedImpactSubScore));
    }

    private double roundUp1(double d) {
        int integerInput = (int)(d * 100000.0);
        if (integerInput % 10000 == 0) {
            return (double)integerInput / 100000.0;
        }
        return Math.floor((double)(integerInput / 10000) + 1.0) / 10.0;
    }

    @Override
    public String getVector() {
        return "CVSS:3.1/AV:" + this.av.shorthand + "/AC:" + this.ac.shorthand + "/PR:" + this.pr.shorthand + "/UI:" + this.ui.shorthand + "/S:" + this.s.shorthand + "/C:" + this.c.shorthand + "/I:" + this.i.shorthand + "/A:" + this.a.shorthand + (this.e != null && this.rl != null && this.rc != null ? "/E:" + this.e.shorthand + "/RL:" + this.rl.shorthand + "/RC:" + this.rc.shorthand : "") + "/CR:" + this.cr.shorthand + "/IR:" + this.ir.shorthand + "/AR:" + this.ar.shorthand + "/MAV:" + this.mav.shorthand + "/MAC:" + this.mac.shorthand + "/MPR:" + this.mpr.shorthand + "/MUI:" + this.mui.shorthand + "/MS:" + this.ms.shorthand + "/MC:" + this.mc.shorthand + "/MI:" + this.mi.shorthand + "/MA:" + this.ma.shorthand;
    }

    public ModifiedAttackVector getModifiedAttackVector() {
        return this.mav;
    }

    public ModifiedAttackComplexity getModifiedAttackComplexity() {
        return this.mac;
    }

    public ModifiedPrivilegesRequired getModifiedPrivilegesRequired() {
        return this.mpr;
    }

    public ModifiedUserInteraction getModifiedUserInteraction() {
        return this.mui;
    }

    public ModifiedScope getModifiedScope() {
        return this.ms;
    }

    public ModifiedCIA getModifiedConfidentialityImpact() {
        return this.mc;
    }

    public ModifiedCIA getModifiedIntegrityImpact() {
        return this.mi;
    }

    public ModifiedCIA getModifiedAvailabilityImpact() {
        return this.ma;
    }

    public ConfidentialityRequirement getConfidentialityRequirement() {
        return this.cr;
    }

    public IntegrityRequirement getIntegrityRequirement() {
        return this.ir;
    }

    public AvailabilityRequirement getAvailabilityRequirement() {
        return this.ar;
    }

    public static enum ModifiedCIA {
        NOT_DEFINED(0.0, 'X'),
        NONE(0.0, 'N'),
        LOW(0.22, 'L'),
        HIGH(0.56, 'H');

        protected final double weight;
        protected final char shorthand;

        private ModifiedCIA(double weight, char shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static ModifiedCIA fromChar(char c) {
            for (ModifiedCIA e : ModifiedCIA.values()) {
                if (e.shorthand != c) continue;
                return e;
            }
            return null;
        }
    }

    public static enum ModifiedScope {
        NOT_DEFINED(0.0, 'X'),
        UNCHANGED(6.42, 'U'),
        CHANGED(7.52, 'C');

        protected final double weight;
        protected final char shorthand;

        private ModifiedScope(double weight, char shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static ModifiedScope fromChar(char c) {
            for (ModifiedScope e : ModifiedScope.values()) {
                if (e.shorthand != c) continue;
                return e;
            }
            return null;
        }
    }

    public static enum ModifiedUserInteraction {
        NOT_DEFINED(0.0, 'X'),
        NONE(0.85, 'N'),
        REQUIRED(0.62, 'R');

        protected final double weight;
        protected final char shorthand;

        private ModifiedUserInteraction(double weight, char shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static ModifiedUserInteraction fromChar(char c) {
            for (ModifiedUserInteraction e : ModifiedUserInteraction.values()) {
                if (e.shorthand != c) continue;
                return e;
            }
            return null;
        }
    }

    public static enum ModifiedPrivilegesRequired {
        NOT_DEFINED(0.0, 0.0, 'X'),
        NONE(0.85, 0.85, 'N'),
        LOW(0.62, 0.68, 'L'),
        HIGH(0.27, 0.5, 'H');

        protected final double weight;
        protected final double scopeChangedWeight;
        protected final char shorthand;

        private ModifiedPrivilegesRequired(double weight, double scopeChangedWeight, char shorthand) {
            this.weight = weight;
            this.scopeChangedWeight = scopeChangedWeight;
            this.shorthand = shorthand;
        }

        public static ModifiedPrivilegesRequired fromChar(char c) {
            for (ModifiedPrivilegesRequired e : ModifiedPrivilegesRequired.values()) {
                if (e.shorthand != c) continue;
                return e;
            }
            return null;
        }
    }

    public static enum ModifiedAttackComplexity {
        NOT_DEFINED(0.0, 'X'),
        LOW(0.77, 'L'),
        HIGH(0.44, 'H');

        protected final double weight;
        protected final char shorthand;

        private ModifiedAttackComplexity(double weight, char shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static ModifiedAttackComplexity fromChar(char c) {
            for (ModifiedAttackComplexity e : ModifiedAttackComplexity.values()) {
                if (e.shorthand != c) continue;
                return e;
            }
            return null;
        }
    }

    public static enum ModifiedAttackVector {
        NOT_DEFINED(0.0, 'X'),
        NETWORK(0.85, 'N'),
        ADJACENT(0.62, 'A'),
        LOCAL(0.55, 'L'),
        PHYSICAL(0.2, 'P');

        protected final double weight;
        protected final char shorthand;

        private ModifiedAttackVector(double weight, char shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static ModifiedAttackVector fromChar(char c) {
            for (ModifiedAttackVector e : ModifiedAttackVector.values()) {
                if (e.shorthand != c) continue;
                return e;
            }
            return null;
        }
    }

    public static enum AvailabilityRequirement {
        NOT_DEFINED(1.0, 'X'),
        LOW(0.5, 'L'),
        MEDIUM(1.0, 'M'),
        HIGH(1.5, 'H');

        protected final double weight;
        protected final char shorthand;

        private AvailabilityRequirement(double weight, char shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static AvailabilityRequirement fromChar(char c) {
            for (AvailabilityRequirement ar : AvailabilityRequirement.values()) {
                if (ar.shorthand != c) continue;
                return ar;
            }
            return null;
        }
    }

    public static enum IntegrityRequirement {
        NOT_DEFINED(1.0, 'X'),
        LOW(0.5, 'L'),
        MEDIUM(1.0, 'M'),
        HIGH(1.5, 'H');

        protected final double weight;
        protected final char shorthand;

        private IntegrityRequirement(double weight, char shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static IntegrityRequirement fromChar(char c) {
            for (IntegrityRequirement ir : IntegrityRequirement.values()) {
                if (ir.shorthand != c) continue;
                return ir;
            }
            return null;
        }
    }

    public static enum ConfidentialityRequirement {
        NOT_DEFINED(1.0, 'X'),
        LOW(0.5, 'L'),
        MEDIUM(1.0, 'M'),
        HIGH(1.5, 'H');

        protected final double weight;
        protected final char shorthand;

        private ConfidentialityRequirement(double weight, char shorthand) {
            this.weight = weight;
            this.shorthand = shorthand;
        }

        public static ConfidentialityRequirement fromChar(char c) {
            for (ConfidentialityRequirement cr : ConfidentialityRequirement.values()) {
                if (cr.shorthand != c) continue;
                return cr;
            }
            return null;
        }
    }
}

