/*
 * Decompiled with CFR 0.152.
 */
package us.springett.nistdatamirror;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Properties;
import us.springett.nistdatamirror.MirrorException;

public class MetaProperties {
    private final long lastModifiedDate;

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public MetaProperties(File file) throws MirrorException {
        Properties properties = new Properties();
        try (FileReader in = new FileReader(file);
             BufferedReader br = new BufferedReader(in);){
            properties.load(br);
        }
        catch (IOException ex) {
            throw new MirrorException("Unable to parse meta file data", ex);
        }
        try {
            String date = properties.getProperty("lastModifiedDate");
            if (date == null) {
                throw new RuntimeException("lastModifiedDate not found in meta file");
            }
            this.lastModifiedDate = ZonedDateTime.parse(date, DateTimeFormatter.ISO_OFFSET_DATE_TIME).toEpochSecond();
        }
        catch (DateTimeParseException ex) {
            throw new MirrorException("Meta file lastModifiedDate cannot be parsed: " + properties.getProperty("lastModifiedDate"), ex);
        }
        try {
            Long.parseLong(properties.getProperty("zipSize"));
        }
        catch (NumberFormatException ex) {
            throw new MirrorException("Meta file zip size cannot be parsed: " + properties.getProperty("zipSize"), ex);
        }
        try {
            Long.parseLong(properties.getProperty("gzSize"));
        }
        catch (NumberFormatException ex) {
            throw new MirrorException("Meta file gz size cannot be parsed: " + properties.getProperty("gzSize"), ex);
        }
        try {
            Long.parseLong(properties.getProperty("size"));
        }
        catch (NumberFormatException ex) {
            throw new MirrorException("Meta file size cannot be parsed: " + properties.getProperty("size"), ex);
        }
    }
}

