/*
 * Decompiled with CFR 0.152.
 */
package us.springett.owasp.riskrating;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.springett.owasp.riskrating.MissingFactorException;
import us.springett.owasp.riskrating.Score;
import us.springett.owasp.riskrating.factors.BusinessImpactFactor;
import us.springett.owasp.riskrating.factors.TechnicalImpactFactor;
import us.springett.owasp.riskrating.factors.ThreatAgentFactor;
import us.springett.owasp.riskrating.factors.VulnerabilityFactor;

public class OwaspRiskRating {
    public static final String VECTOR_PATTERN = "SL:\\d/M:\\d/O:\\d/S:\\d/ED:\\d/EE:\\d/A:\\d/ID:\\d/LC:\\d/LI:\\d/LAV:\\d/LAC:\\d/FD:\\d/RD:\\d/NC:\\d/PV:\\d";
    public static final Pattern OWASP_RR_VECTOR_PATTERN = Pattern.compile("SL:\\d/M:\\d/O:\\d/S:\\d/ED:\\d/EE:\\d/A:\\d/ID:\\d/LC:\\d/LI:\\d/LAV:\\d/LAC:\\d/FD:\\d/RD:\\d/NC:\\d/PV:\\d");
    private ThreatAgentFactor.SkillLevel skillLevel;
    private ThreatAgentFactor.Motive motive;
    private ThreatAgentFactor.Opportunity opportunity;
    private ThreatAgentFactor.Size size;
    private VulnerabilityFactor.EaseOfDiscovery easeOfDiscovery;
    private VulnerabilityFactor.EaseOfExploit easeOfExploit;
    private VulnerabilityFactor.Awareness awareness;
    private VulnerabilityFactor.IntrusionDetection intrusionDetection;
    private TechnicalImpactFactor.LossOfConfidentiality lossOfConfidentiality;
    private TechnicalImpactFactor.LossOfIntegrity lossOfIntegrity;
    private TechnicalImpactFactor.LossOfAvailability lossOfAvailability;
    private TechnicalImpactFactor.LossOfAccountability lossOfAccountability;
    private BusinessImpactFactor.FinancialDamage financialDamage;
    private BusinessImpactFactor.ReputationDamage reputationDamage;
    private BusinessImpactFactor.NonCompliance nonCompliance;
    private BusinessImpactFactor.PrivacyViolation privacyViolation;

    public Score calculateScore() throws MissingFactorException {
        if (this.skillLevel == null || this.motive == null || this.opportunity == null || this.size == null || this.easeOfDiscovery == null || this.easeOfExploit == null || this.awareness == null || this.intrusionDetection == null || this.lossOfConfidentiality == null || this.lossOfIntegrity == null || this.lossOfAvailability == null || this.lossOfAccountability == null || this.financialDamage == null || this.reputationDamage == null || this.nonCompliance == null || this.privacyViolation == null) {
            throw new MissingFactorException();
        }
        double likelihood = (this.skillLevel.getLikelihood() + this.motive.getLikelihood() + this.opportunity.getLikelihood() + this.size.getLikelihood() + this.easeOfDiscovery.getLikelihood() + this.easeOfExploit.getLikelihood() + this.awareness.getLikelihood() + this.intrusionDetection.getLikelihood()) / 8.0;
        double technicalImpact = (this.lossOfConfidentiality.getLikelihood() + this.lossOfIntegrity.getLikelihood() + this.lossOfAvailability.getLikelihood() + this.lossOfAccountability.getLikelihood()) / 4.0;
        double businessImpact = (this.financialDamage.getLikelihood() + this.reputationDamage.getLikelihood() + this.nonCompliance.getLikelihood() + this.privacyViolation.getLikelihood()) / 4.0;
        return new Score(likelihood, technicalImpact, businessImpact);
    }

    public static OwaspRiskRating fromVector(String vector) {
        if (vector == null) {
            throw new IllegalArgumentException("Null vector provided");
        }
        Matcher vectorMatcher = OWASP_RR_VECTOR_PATTERN.matcher(vector);
        if (vectorMatcher.matches()) {
            String matchedVector = vectorMatcher.group();
            StringTokenizer st = new StringTokenizer(matchedVector, "/");
            OwaspRiskRating result = new OwaspRiskRating();
            result.with(ThreatAgentFactor.SkillLevel.fromString(st.nextElement().toString().split(":")[1]));
            result.with(ThreatAgentFactor.Motive.fromString(st.nextElement().toString().split(":")[1]));
            result.with(ThreatAgentFactor.Opportunity.fromString(st.nextElement().toString().split(":")[1]));
            result.with(ThreatAgentFactor.Size.fromString(st.nextElement().toString().split(":")[1]));
            result.with(VulnerabilityFactor.EaseOfDiscovery.fromString(st.nextElement().toString().split(":")[1]));
            result.with(VulnerabilityFactor.EaseOfExploit.fromString(st.nextElement().toString().split(":")[1]));
            result.with(VulnerabilityFactor.Awareness.fromString(st.nextElement().toString().split(":")[1]));
            result.with(VulnerabilityFactor.IntrusionDetection.fromString(st.nextElement().toString().split(":")[1]));
            result.with(TechnicalImpactFactor.LossOfConfidentiality.fromString(st.nextElement().toString().split(":")[1]));
            result.with(TechnicalImpactFactor.LossOfIntegrity.fromString(st.nextElement().toString().split(":")[1]));
            result.with(TechnicalImpactFactor.LossOfAvailability.fromString(st.nextElement().toString().split(":")[1]));
            result.with(TechnicalImpactFactor.LossOfAccountability.fromString(st.nextElement().toString().split(":")[1]));
            result.with(BusinessImpactFactor.FinancialDamage.fromString(st.nextElement().toString().split(":")[1]));
            result.with(BusinessImpactFactor.ReputationDamage.fromString(st.nextElement().toString().split(":")[1]));
            result.with(BusinessImpactFactor.NonCompliance.fromString(st.nextElement().toString().split(":")[1]));
            result.with(BusinessImpactFactor.PrivacyViolation.fromString(st.nextElement().toString().split(":")[1]));
            return result;
        }
        throw new IllegalArgumentException("Provided vector " + vector + " does not match OWASP RR Vector pattern " + VECTOR_PATTERN);
    }

    public OwaspRiskRating with(ThreatAgentFactor.SkillLevel skillLevel) {
        this.skillLevel = skillLevel;
        return this;
    }

    public OwaspRiskRating with(ThreatAgentFactor.Motive motive) {
        this.motive = motive;
        return this;
    }

    public OwaspRiskRating with(ThreatAgentFactor.Opportunity opportunity) {
        this.opportunity = opportunity;
        return this;
    }

    public OwaspRiskRating with(ThreatAgentFactor.Size size) {
        this.size = size;
        return this;
    }

    public OwaspRiskRating with(VulnerabilityFactor.EaseOfDiscovery easeOfDiscovery) {
        this.easeOfDiscovery = easeOfDiscovery;
        return this;
    }

    public OwaspRiskRating with(VulnerabilityFactor.EaseOfExploit easeOfExploit) {
        this.easeOfExploit = easeOfExploit;
        return this;
    }

    public OwaspRiskRating with(VulnerabilityFactor.Awareness awareness) {
        this.awareness = awareness;
        return this;
    }

    public OwaspRiskRating with(VulnerabilityFactor.IntrusionDetection intrusionDetection) {
        this.intrusionDetection = intrusionDetection;
        return this;
    }

    public OwaspRiskRating with(TechnicalImpactFactor.LossOfConfidentiality lossOfConfidentiality) {
        this.lossOfConfidentiality = lossOfConfidentiality;
        return this;
    }

    public OwaspRiskRating with(TechnicalImpactFactor.LossOfIntegrity lossOfIntegrity) {
        this.lossOfIntegrity = lossOfIntegrity;
        return this;
    }

    public OwaspRiskRating with(TechnicalImpactFactor.LossOfAvailability lossOfAvailability) {
        this.lossOfAvailability = lossOfAvailability;
        return this;
    }

    public OwaspRiskRating with(TechnicalImpactFactor.LossOfAccountability lossOfAccountability) {
        this.lossOfAccountability = lossOfAccountability;
        return this;
    }

    public OwaspRiskRating with(BusinessImpactFactor.FinancialDamage financialDamage) {
        this.financialDamage = financialDamage;
        return this;
    }

    public OwaspRiskRating with(BusinessImpactFactor.ReputationDamage reputationDamage) {
        this.reputationDamage = reputationDamage;
        return this;
    }

    public OwaspRiskRating with(BusinessImpactFactor.NonCompliance nonCompliance) {
        this.nonCompliance = nonCompliance;
        return this;
    }

    public OwaspRiskRating with(BusinessImpactFactor.PrivacyViolation privacyViolation) {
        this.privacyViolation = privacyViolation;
        return this;
    }

    public ThreatAgentFactor.SkillLevel getSkillLevel() {
        return this.skillLevel;
    }

    public ThreatAgentFactor.Motive getMotive() {
        return this.motive;
    }

    public ThreatAgentFactor.Opportunity getOpportunity() {
        return this.opportunity;
    }

    public ThreatAgentFactor.Size getSize() {
        return this.size;
    }

    public VulnerabilityFactor.EaseOfDiscovery getEaseOfDiscovery() {
        return this.easeOfDiscovery;
    }

    public VulnerabilityFactor.EaseOfExploit getEaseOfExploit() {
        return this.easeOfExploit;
    }

    public VulnerabilityFactor.Awareness getAwareness() {
        return this.awareness;
    }

    public VulnerabilityFactor.IntrusionDetection getIntrusionDetection() {
        return this.intrusionDetection;
    }

    public TechnicalImpactFactor.LossOfConfidentiality getLossOfConfidentiality() {
        return this.lossOfConfidentiality;
    }

    public TechnicalImpactFactor.LossOfIntegrity getLossOfIntegrity() {
        return this.lossOfIntegrity;
    }

    public TechnicalImpactFactor.LossOfAvailability getLossOfAvailability() {
        return this.lossOfAvailability;
    }

    public TechnicalImpactFactor.LossOfAccountability getLossOfAccountability() {
        return this.lossOfAccountability;
    }

    public BusinessImpactFactor.FinancialDamage getFinancialDamage() {
        return this.financialDamage;
    }

    public BusinessImpactFactor.ReputationDamage getReputationDamage() {
        return this.reputationDamage;
    }

    public BusinessImpactFactor.NonCompliance getNonCompliance() {
        return this.nonCompliance;
    }

    public BusinessImpactFactor.PrivacyViolation getPrivacyViolation() {
        return this.privacyViolation;
    }
}

