/*
 * Decompiled with CFR 0.152.
 */
package us.springett.owasp.riskrating;

import us.springett.owasp.riskrating.Level;

public class Score {
    private double likelihoodScore;
    private double technicalImpactScore;
    private double businessImpactScore;

    public Score(double likelihoodScore, double technicalImpactScore, double businessImpactScore) {
        this.likelihoodScore = likelihoodScore;
        this.technicalImpactScore = technicalImpactScore;
        this.businessImpactScore = businessImpactScore;
    }

    public double getLikelihoodScore() {
        return this.likelihoodScore;
    }

    public double getTechnicalImpactScore() {
        return this.technicalImpactScore;
    }

    public double getBusinessImpactScore() {
        return this.businessImpactScore;
    }

    public Level getLikelihood() {
        return this.rank(this.likelihoodScore);
    }

    public Level getTechnicalImpact() {
        return this.rank(this.technicalImpactScore);
    }

    public Level getBusinessImpact() {
        return this.rank(this.businessImpactScore);
    }

    private Level rank(double value) {
        if (value < 3.0) {
            return Level.LOW;
        }
        if (value < 6.0) {
            return Level.MEDIUM;
        }
        return Level.HIGH;
    }
}

