/*
 * Decompiled with CFR 0.152.
 */
package us.springett.owasp.riskrating.factors;

import us.springett.owasp.riskrating.factors.ILikelihood;

public class BusinessImpactFactor {
    private BusinessImpactFactor() {
    }

    public static enum PrivacyViolation implements ILikelihood
    {
        ONE_INDIVIDUAL(3.0),
        HUNDREDS_OF_PEOPLE(5.0),
        THOUSANDS_OF_PEOPLE(7.0),
        MILLIONS_OF_PEOPLE(9.0);

        private double likelihood;

        @Override
        public double getLikelihood() {
            return this.likelihood;
        }

        private PrivacyViolation(double likelihood) {
            this.likelihood = likelihood;
        }

        public static PrivacyViolation fromDouble(double level) {
            for (PrivacyViolation privacyViolation : PrivacyViolation.values()) {
                if (privacyViolation.likelihood != level) continue;
                return privacyViolation;
            }
            return null;
        }

        public static PrivacyViolation fromString(String level) {
            return PrivacyViolation.fromDouble(Double.valueOf(level));
        }
    }

    public static enum NonCompliance implements ILikelihood
    {
        MINOR_VIOLATION(2.0),
        CLEAR_VIOLATION(5.0),
        HIGH_PROFILE_VIOLATION(7.0);

        private double likelihood;

        @Override
        public double getLikelihood() {
            return this.likelihood;
        }

        private NonCompliance(double likelihood) {
            this.likelihood = likelihood;
        }

        public static NonCompliance fromDouble(double level) {
            for (NonCompliance nonCompliance : NonCompliance.values()) {
                if (nonCompliance.likelihood != level) continue;
                return nonCompliance;
            }
            return null;
        }

        public static NonCompliance fromString(String level) {
            return NonCompliance.fromDouble(Double.valueOf(level));
        }
    }

    public static enum ReputationDamage implements ILikelihood
    {
        MINIMAL_DAMAGE(1.0),
        LOSS_OF_MAJOR_ACCOUNTS(4.0),
        LOSS_OF_GOODWILL(5.0),
        BRAND_DAMAGE(9.0);

        private double likelihood;

        @Override
        public double getLikelihood() {
            return this.likelihood;
        }

        private ReputationDamage(double likelihood) {
            this.likelihood = likelihood;
        }

        public static ReputationDamage fromDouble(double level) {
            for (ReputationDamage reputationDamage : ReputationDamage.values()) {
                if (reputationDamage.likelihood != level) continue;
                return reputationDamage;
            }
            return null;
        }

        public static ReputationDamage fromString(String level) {
            return ReputationDamage.fromDouble(Double.valueOf(level));
        }
    }

    public static enum FinancialDamage implements ILikelihood
    {
        LESS_THAN_THE_COST_TO_FIX_THE_VULNERABILITY(1.0),
        MINOR_EFFECT_ON_ANNUAL_PROFIT(3.0),
        SIGNIFICANT_EFFECT_ON_ANNUAL_PROFIT(7.0),
        BANKRUPTCY(9.0);

        private double likelihood;

        @Override
        public double getLikelihood() {
            return this.likelihood;
        }

        private FinancialDamage(double likelihood) {
            this.likelihood = likelihood;
        }

        public static FinancialDamage fromDouble(double level) {
            for (FinancialDamage financialDamage : FinancialDamage.values()) {
                if (financialDamage.likelihood != level) continue;
                return financialDamage;
            }
            return null;
        }

        public static FinancialDamage fromString(String level) {
            return FinancialDamage.fromDouble(Double.valueOf(level));
        }
    }
}

