/*
 * Decompiled with CFR 0.152.
 */
package us.springett.owasp.riskrating.factors;

import us.springett.owasp.riskrating.factors.ILikelihood;

public class TechnicalImpactFactor {
    private TechnicalImpactFactor() {
    }

    public static enum LossOfAccountability implements ILikelihood
    {
        FULLY_TRACEABLE(1.0),
        POSSIBLY_TRACEABLE(7.0),
        COMPLETELY_ANONYMOUS(9.0);

        private double likelihood;

        @Override
        public double getLikelihood() {
            return this.likelihood;
        }

        private LossOfAccountability(double likelihood) {
            this.likelihood = likelihood;
        }

        public static LossOfAccountability fromDouble(double level) {
            for (LossOfAccountability lossOfAccountability : LossOfAccountability.values()) {
                if (lossOfAccountability.likelihood != level) continue;
                return lossOfAccountability;
            }
            return null;
        }

        public static LossOfAccountability fromString(String level) {
            return LossOfAccountability.fromDouble(Double.valueOf(level));
        }
    }

    public static enum LossOfAvailability implements ILikelihood
    {
        MINIMAL_SECONDARY_SERVICES_INTERRUPTED(1.0),
        MINIMAL_PRIMARY_SERVICES_INTERRUPTED(5.0),
        EXTENSIVE_SECONDARY_SERVICES_INTERRUPTED(5.0),
        EXTENSIVE_PRIMARY_SERVICES_INTERRUPTED(7.0),
        ALL_SERVICES_COMPLETELY_LOST(9.0);

        private double likelihood;

        @Override
        public double getLikelihood() {
            return this.likelihood;
        }

        private LossOfAvailability(double likelihood) {
            this.likelihood = likelihood;
        }

        public static LossOfAvailability fromDouble(double level) {
            for (LossOfAvailability lossOfAvailability : LossOfAvailability.values()) {
                if (lossOfAvailability.likelihood != level) continue;
                return lossOfAvailability;
            }
            return null;
        }

        public static LossOfAvailability fromString(String level) {
            return LossOfAvailability.fromDouble(Double.valueOf(level));
        }
    }

    public static enum LossOfIntegrity implements ILikelihood
    {
        MINIMAL_SLIGHTLY_CORRUPT_DATA(1.0),
        MINIMAL_SERIOUSLY_CORRUPT_DATA(3.0),
        EXTENSIVE_SLIGHTLY_CORRUPT_DATA(5.0),
        EXTENSIVE_SERIOUSLY_CORRUPT_DATA(7.0),
        ALL_DATA_TOTALLY_CORRUPT(9.0);

        private double likelihood;

        @Override
        public double getLikelihood() {
            return this.likelihood;
        }

        private LossOfIntegrity(double likelihood) {
            this.likelihood = likelihood;
        }

        public static LossOfIntegrity fromDouble(double level) {
            for (LossOfIntegrity lossOfIntegrity : LossOfIntegrity.values()) {
                if (lossOfIntegrity.likelihood != level) continue;
                return lossOfIntegrity;
            }
            return null;
        }

        public static LossOfIntegrity fromString(String level) {
            return LossOfIntegrity.fromDouble(Double.valueOf(level));
        }
    }

    public static enum LossOfConfidentiality implements ILikelihood
    {
        MINIMAL_NON_SENSITIVE_DATA_DISCLOSED(2.0),
        MINIMAL_CRITICAL_DATA_DISCLOSED(6.0),
        EXTENSIVE_NON_SENSITIVE_DATA_DISCLOSED(6.0),
        EXTENSIVE_CRITICAL_DATA_DISCLOSED(7.0),
        ALL_DATA_DISCLOSED(9.0);

        private double likelihood;

        @Override
        public double getLikelihood() {
            return this.likelihood;
        }

        private LossOfConfidentiality(double likelihood) {
            this.likelihood = likelihood;
        }

        public static LossOfConfidentiality fromDouble(double level) {
            for (LossOfConfidentiality lossOfConfidentiality : LossOfConfidentiality.values()) {
                if (lossOfConfidentiality.likelihood != level) continue;
                return lossOfConfidentiality;
            }
            return null;
        }

        public static LossOfConfidentiality fromString(String level) {
            return LossOfConfidentiality.fromDouble(Double.valueOf(level));
        }
    }
}

