/*
 * Decompiled with CFR 0.152.
 */
package us.springett.owasp.riskrating.factors;

import us.springett.owasp.riskrating.factors.ILikelihood;

public class ThreatAgentFactor {
    private ThreatAgentFactor() {
    }

    public static enum Size implements ILikelihood
    {
        DEVELOPERS(2.0),
        SYSTEM_ADMINISTRATORS(2.0),
        INTRANET_USERS(4.0),
        PARTNERS(5.0),
        AUTHENTICATED_USERS(6.0),
        ANONYMOUS_INTERNET_USERS(9.0);

        private double likelihood;

        @Override
        public double getLikelihood() {
            return this.likelihood;
        }

        private Size(double likelihood) {
            this.likelihood = likelihood;
        }

        public static Size fromDouble(double level) {
            for (Size size : Size.values()) {
                if (size.likelihood != level) continue;
                return size;
            }
            return null;
        }

        public static Size fromString(String level) {
            return Size.fromDouble(Double.valueOf(level));
        }
    }

    public static enum Opportunity implements ILikelihood
    {
        FULL_ACCESS_OR_EXPENSIVE_RESOURCES_REQUIRED(0.0),
        SPECIAL_ACCESS_OR_RESOURCES_REQUIRED(4.0),
        SOME_ACCESS_OR_RESOURCES_REQUIRED(7.0),
        NO_ACCESS_OR_RESOURCES_REQUIRED(9.0);

        private double likelihood;

        @Override
        public double getLikelihood() {
            return this.likelihood;
        }

        private Opportunity(double likelihood) {
            this.likelihood = likelihood;
        }

        public static Opportunity fromDouble(double level) {
            for (Opportunity opportunity : Opportunity.values()) {
                if (opportunity.likelihood != level) continue;
                return opportunity;
            }
            return null;
        }

        public static Opportunity fromString(String level) {
            return Opportunity.fromDouble(Double.valueOf(level));
        }
    }

    public static enum Motive implements ILikelihood
    {
        LOW_OR_NO_REWARD(1.0),
        POSSIBLE_REWARD(4.0),
        HIGH_REWARD(9.0);

        private double likelihood;

        @Override
        public double getLikelihood() {
            return this.likelihood;
        }

        private Motive(double likelihood) {
            this.likelihood = likelihood;
        }

        public static Motive fromDouble(double level) {
            for (Motive motive : Motive.values()) {
                if (motive.likelihood != level) continue;
                return motive;
            }
            return null;
        }

        public static Motive fromString(String level) {
            return Motive.fromDouble(Double.valueOf(level));
        }
    }

    public static enum SkillLevel implements ILikelihood
    {
        NO_TECHNICAL_SKILLS(1.0),
        SOME_TECHNICAL_SKILLS(3.0),
        ADVANCED_COMPUTER_USER(5.0),
        NETWORK_AND_PROGRAMMING_SKILLS(6.0),
        SECURITY_PENETRATION_SKILLS(9.0);

        private double likelihood;

        @Override
        public double getLikelihood() {
            return this.likelihood;
        }

        private SkillLevel(double likelihood) {
            this.likelihood = likelihood;
        }

        public static SkillLevel fromDouble(double level) {
            for (SkillLevel skillLevel : SkillLevel.values()) {
                if (skillLevel.likelihood != level) continue;
                return skillLevel;
            }
            return null;
        }

        public static SkillLevel fromString(String level) {
            return SkillLevel.fromDouble(Double.valueOf(level));
        }
    }
}

