/*
 * Decompiled with CFR 0.152.
 */
package us.springett.owasp.riskrating.factors;

import us.springett.owasp.riskrating.factors.ILikelihood;

public class VulnerabilityFactor {
    private VulnerabilityFactor() {
    }

    public static enum IntrusionDetection implements ILikelihood
    {
        ACTIVE_DETECTION_IN_APPLICATION(1.0),
        LOGGED_AND_REVIEWED(3.0),
        LOGGED_WITHOUT_REVIEW(8.0),
        NOT_LOGGED(9.0);

        private double likelihood;

        @Override
        public double getLikelihood() {
            return this.likelihood;
        }

        private IntrusionDetection(double likelihood) {
            this.likelihood = likelihood;
        }

        public static IntrusionDetection fromDouble(double level) {
            for (IntrusionDetection intrusionDetection : IntrusionDetection.values()) {
                if (intrusionDetection.likelihood != level) continue;
                return intrusionDetection;
            }
            return null;
        }

        public static IntrusionDetection fromString(String level) {
            return IntrusionDetection.fromDouble(Double.valueOf(level));
        }
    }

    public static enum Awareness implements ILikelihood
    {
        UNKNOWN(1.0),
        HIDDEN(4.0),
        OBVIOUS(6.0),
        PUBLIC_KNOWLEDGE(9.0);

        private double likelihood;

        @Override
        public double getLikelihood() {
            return this.likelihood;
        }

        private Awareness(double likelihood) {
            this.likelihood = likelihood;
        }

        public static Awareness fromDouble(double level) {
            for (Awareness awareness : Awareness.values()) {
                if (awareness.likelihood != level) continue;
                return awareness;
            }
            return null;
        }

        public static Awareness fromString(String level) {
            return Awareness.fromDouble(Double.valueOf(level));
        }
    }

    public static enum EaseOfExploit implements ILikelihood
    {
        THEORETICAL(1.0),
        DIFFICULT(3.0),
        EASY(5.0),
        AUTOMATED_TOOLS_AVAILABLE(9.0);

        private double likelihood;

        @Override
        public double getLikelihood() {
            return this.likelihood;
        }

        private EaseOfExploit(double likelihood) {
            this.likelihood = likelihood;
        }

        public static EaseOfExploit fromDouble(double level) {
            for (EaseOfExploit easeOfExploit : EaseOfExploit.values()) {
                if (easeOfExploit.likelihood != level) continue;
                return easeOfExploit;
            }
            return null;
        }

        public static EaseOfExploit fromString(String level) {
            return EaseOfExploit.fromDouble(Double.valueOf(level));
        }
    }

    public static enum EaseOfDiscovery implements ILikelihood
    {
        PRACTICALLY_IMPOSSIBLE(1.0),
        DIFFICULT(3.0),
        EASY(7.0),
        AUTOMATED_TOOLS_AVAILABLE(9.0);

        private double likelihood;

        @Override
        public double getLikelihood() {
            return this.likelihood;
        }

        private EaseOfDiscovery(double likelihood) {
            this.likelihood = likelihood;
        }

        public static EaseOfDiscovery fromDouble(double level) {
            for (EaseOfDiscovery easeOfDiscovery : EaseOfDiscovery.values()) {
                if (easeOfDiscovery.likelihood != level) continue;
                return easeOfDiscovery;
            }
            return null;
        }

        public static EaseOfDiscovery fromString(String level) {
            return EaseOfDiscovery.fromDouble(Double.valueOf(level));
        }
    }
}

